"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleExecuteCommand = void 0;
var _uuid = require("uuid");
var _react = _interopRequireDefault(require("react"));
var _translations = require("./translations");
var _console_code_block = require("../../console_code_block");
var _handle_input_area_state = require("./handle_input_area_state");
var _help_command_argument = require("../../builtin_commands/help_command_argument");
var _unknown_comand = require("../../unknown_comand");
var _bad_argument = require("../../bad_argument");
var _validation_error = require("../../validation_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/console_state/state_update_handlers/handle_execute_command.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable complexity */
const toCliArgumentOption = argName => `--${argName}`;
const getRequiredArguments = argDefinitions => {
  if (!argDefinitions) {
    return [];
  }
  return Object.entries(argDefinitions).filter(([_, argDef]) => argDef.required).map(([argName]) => argName);
};
const getUnknownArguments = (inputArgs, argDefinitions) => {
  const response = [];
  Object.keys(inputArgs).forEach(argName => {
    if (argName !== 'help' && (!argDefinitions || !argDefinitions[argName])) {
      response.push(argName);
    }
  });
  return response;
};
const getExclusiveOrArgs = argDefinitions => {
  if (!argDefinitions) {
    return [];
  }
  const exclusiveOrArgs = [];
  return Object.entries(argDefinitions).reduce((acc, [argName, argDef]) => {
    if (argDef.exclusiveOr) {
      acc.push(argName);
    }
    return acc;
  }, exclusiveOrArgs);
};
const updateStateWithNewCommandHistoryItem = (state, newHistoryItem) => {
  var _newHistoryItem$comma;
  const updatedState = (0, _handle_input_area_state.handleInputAreaState)(state, {
    type: 'updateInputHistoryState',
    payload: {
      command: newHistoryItem.command.input,
      display: newHistoryItem.command.inputDisplay,
      argState: (_newHistoryItem$comma = newHistoryItem.command.argState) !== null && _newHistoryItem$comma !== void 0 ? _newHistoryItem$comma : {}
    }
  });
  updatedState.commandHistory = [...state.commandHistory, newHistoryItem];
  return updatedState;
};
const UnknownCommandDefinition = {
  name: 'unknown-command',
  about: 'unknown command',
  RenderComponent: () => null
};
const createCommandExecutionState = (store = {}) => {
  return {
    status: 'pending',
    store
  };
};
const cloneCommandDefinitionWithNewRenderComponent = (command, RenderComponent) => {
  return {
    ...command,
    commandDefinition: {
      ...command.commandDefinition,
      // We use the original command definition, but replace
      // the RenderComponent for this invocation
      RenderComponent
    }
  };
};
const createCommandHistoryEntry = (command, state = createCommandExecutionState(), isValid = true) => {
  return {
    id: (0, _uuid.v4)(),
    isValid,
    enteredAt: new Date().toISOString(),
    command,
    state
  };
};
const handleExecuteCommand = (state, action) => {
  const {
    parsedInput,
    enteredCommand,
    input: fullInputText
  } = action.payload;
  if (parsedInput.name === '') {
    return state;
  }
  const commandDefinition = enteredCommand === null || enteredCommand === void 0 ? void 0 : enteredCommand.commandDefinition;

  // Unknown command
  if (!commandDefinition) {
    return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry({
      input: parsedInput.input,
      inputDisplay: fullInputText,
      args: parsedInput,
      commandDefinition: {
        ...UnknownCommandDefinition,
        RenderComponent: _unknown_comand.UnknownCommand
      }
    }, undefined, false));
  }
  const command = {
    input: parsedInput.input,
    inputDisplay: fullInputText,
    args: parsedInput,
    argState: enteredCommand === null || enteredCommand === void 0 ? void 0 : enteredCommand.argState,
    commandDefinition
  };
  const requiredArgs = getRequiredArguments(commandDefinition.args);
  const exclusiveOrArgs = getExclusiveOrArgs(commandDefinition.args);
  const exclusiveOrErrorMessage = _translations.executionTranslations.onlyOneFromExclusiveOr(exclusiveOrArgs.map(toCliArgumentOption).join(', '));

  // If args were entered, then validate them
  if (parsedInput.hasArgs) {
    // Show command help
    if (parsedInput.hasArg('help')) {
      if (Object.keys(parsedInput.args).length > 1 || parsedInput.args.help.length > 1 || parsedInput.args.help[0] !== true) {
        return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), undefined, false));
      }
      if (commandDefinition !== null && commandDefinition !== void 0 && commandDefinition.validate) {
        const validationResult = commandDefinition.validate(command);
        if (validationResult !== true) {
          return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _help_command_argument.HelpCommandArgument), createCommandExecutionState({
            errorMessage: validationResult
          }), false));
        }
      }
      return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _help_command_argument.HelpCommandArgument), undefined, false));
    }

    // Command supports no arguments
    if (!commandDefinition.args || Object.keys(commandDefinition.args).length === 0) {
      return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
        errorMessage: _translations.executionTranslations.NO_ARGUMENTS_SUPPORTED
      }), false));
    }

    // no unknown arguments allowed
    const unknownInputArgs = getUnknownArguments(parsedInput.args, commandDefinition.args);
    if (unknownInputArgs.length) {
      return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
        errorMessage: _translations.executionTranslations.unknownArgument(unknownInputArgs.length, parsedInput.name, unknownInputArgs.map(toCliArgumentOption).join(', '))
      }), false));
    }

    // Missing required Arguments
    for (const requiredArg of requiredArgs) {
      if (!parsedInput.args[requiredArg]) {
        return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
          errorMessage: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 264,
              columnNumber: 17
            }
          }, _translations.executionTranslations.missingRequiredArg(requiredArg))
        }), false));
      }
    }

    // Validate exclusiveOr arguments, can only have one.
    const exclusiveArgsUsed = exclusiveOrArgs.filter(arg => parsedInput.args[arg]);
    if (exclusiveArgsUsed.length > 1) {
      return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
        errorMessage: exclusiveOrErrorMessage
      }), false));
    }

    // Validate each argument given to the command
    for (const argName of Object.keys(parsedInput.args)) {
      var _commandDefinition$ar;
      const argDefinition = (_commandDefinition$ar = commandDefinition.args) === null || _commandDefinition$ar === void 0 ? void 0 : _commandDefinition$ar[argName];
      const argInput = parsedInput.args[argName];

      // Unknown argument
      if (!argDefinition) {
        return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
          errorMessage: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 304,
              columnNumber: 17
            }
          }, _translations.executionTranslations.unsupportedArg(argName))
        }), false));
      }

      // does not allow multiple values
      if (!argDefinition.allowMultiples && Array.isArray(argInput) && argInput.length > 1) {
        return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
          errorMessage: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 320,
              columnNumber: 17
            }
          }, _translations.executionTranslations.noMultiplesAllowed(argName))
        }), false));
      }
      if (argDefinition.mustHaveValue !== undefined && argDefinition.mustHaveValue !== false) {
        let dataValidationError = '';
        if (argInput.length === 0) {
          dataValidationError = _translations.executionTranslations.mustHaveValue(argName);
        } else {
          argInput.some((argValue, index) => {
            switch (argDefinition.mustHaveValue) {
              case true:
              case 'non-empty-string':
                if (typeof argValue === 'boolean') {
                  dataValidationError = _translations.executionTranslations.mustHaveValue(argName);
                } else if (argDefinition.mustHaveValue === 'non-empty-string' && (argValue !== null && argValue !== void 0 ? argValue : '').trim().length === 0) {
                  dataValidationError = _translations.executionTranslations.mustHaveValue(argName);
                }
                break;
              case 'truthy':
                if (!argValue) {
                  dataValidationError = _translations.executionTranslations.mustHaveValue(argName);
                }
                break;
              case 'number':
              case 'number-greater-than-zero':
                if (typeof argValue === 'boolean') {
                  dataValidationError = _translations.executionTranslations.mustHaveValue(argName);
                } else {
                  const valueNumber = Number(argValue);
                  if (!Number.isSafeInteger(valueNumber)) {
                    dataValidationError = _translations.executionTranslations.mustBeNumber(argName);
                  } else {
                    if (argDefinition.mustHaveValue === 'number-greater-than-zero') {
                      if (valueNumber <= 0) {
                        dataValidationError = _translations.executionTranslations.mustBeGreaterThanZero(argName);
                      }
                    }
                  }

                  // If no errors, then update (mutate) the value so that correct
                  // format reaches the execution component
                  if (!dataValidationError) {
                    argInput[index] = valueNumber;
                  }
                }
                break;
            }
            return !!dataValidationError;
          });
        }
        if (dataValidationError) {
          return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
            errorMessage: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 393,
                columnNumber: 31
              }
            }, dataValidationError)
          }), false));
        }
      }

      // Call validation callback if one was defined for the argument
      if (argDefinition.validate) {
        const validationResult = argDefinition.validate(argInput);
        if (validationResult !== true) {
          return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
            errorMessage: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 412,
                columnNumber: 19
              }
            }, _translations.executionTranslations.argValueValidatorError(argName, validationResult))
          }), false));
        }
      }
    }
  } else if (requiredArgs.length > 0) {
    return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
      errorMessage: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 430,
          columnNumber: 13
        }
      }, _translations.executionTranslations.missingArguments(requiredArgs.map(argName => toCliArgumentOption(argName)).join(', ')))
    }), false));
  } else if (exclusiveOrArgs.length > 0) {
    return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
      errorMessage: exclusiveOrErrorMessage
    }), false));
  } else if (commandDefinition.mustHaveArgs) {
    return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _bad_argument.BadArgument), createCommandExecutionState({
      errorMessage: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 458,
          columnNumber: 13
        }
      }, _translations.executionTranslations.MUST_HAVE_AT_LEAST_ONE_ARG)
    }), false));
  }

  // if the Command definition has a `validate()` callback, then call it now
  if (commandDefinition.validate) {
    const validationResult = commandDefinition.validate(command);
    if (validationResult !== true) {
      return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(cloneCommandDefinitionWithNewRenderComponent(command, _validation_error.ValidationError), createCommandExecutionState({
        errorMessage: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 475,
            columnNumber: 27
          }
        }, validationResult)
      }), false));
    }
  }

  // All is good. Execute the command
  return updateStateWithNewCommandHistoryItem(state, createCommandHistoryEntry(command));
};
exports.handleExecuteCommand = handleExecuteCommand;