"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBuiltinCommands = exports.HELP_GROUPS = exports.COMMON_ARGS = void 0;
var _i18n = require("@kbn/i18n");
var _clear_command = require("../components/builtin_commands/clear_command");
var _help_command = require("../components/builtin_commands/help_command");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HELP_GROUPS = exports.HELP_GROUPS = Object.freeze({
  supporting: {
    label: _i18n.i18n.translate('xpack.securitySolution.console.builtInCommands.groups.supporting', {
      defaultMessage: 'Supporting commands & parameters'
    })
  }
});
const COMMON_ARGS = exports.COMMON_ARGS = Object.freeze([{
  name: '--comment',
  about: _i18n.i18n.translate('xpack.securitySolution.console.commandList.commonArgs.comment', {
    defaultMessage: 'Add comment to any action Ex: isolate --comment your comment'
  })
}, {
  name: '--help',
  about: _i18n.i18n.translate('xpack.securitySolution.console.commandList.commonArgs.help', {
    defaultMessage: 'Command assistance Ex: isolate --help'
  })
}]);
const getBuiltinCommands = () => {
  return [{
    name: 'help',
    about: _i18n.i18n.translate('xpack.securitySolution.console.builtInCommands.helpAbout', {
      defaultMessage: 'List all available commands'
    }),
    RenderComponent: _help_command.HelpCommand,
    helpGroupLabel: HELP_GROUPS.supporting.label,
    helpCommandPosition: 1
  }, {
    name: 'clear',
    about: _i18n.i18n.translate('xpack.securitySolution.console.builtInCommands.clearAbout', {
      defaultMessage: 'Clear console screen'
    }),
    RenderComponent: _clear_command.ClearCommand,
    helpGroupLabel: HELP_GROUPS.supporting.label,
    helpCommandPosition: 0
  }];
};
exports.getBuiltinCommands = getBuiltinCommands;