"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendGetEndpointProcessesRequest = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../../common/endpoint/constants");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get running processes
 * @param customOptions
 */
const useSendGetEndpointProcessesRequest = customOptions => {
  return (0, _reactQuery.useMutation)(getRunningProcessesData => {
    return _kibana.KibanaServices.get().http.post(_constants.GET_PROCESSES_ROUTE, {
      body: JSON.stringify(getRunningProcessesData),
      version: '2023-10-31'
    });
  }, customOptions);
};
exports.useSendGetEndpointProcessesRequest = useSendGetEndpointProcessesRequest;