"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Management = void 0;
var _routes = require("./routes");
var _reducer = require("./store/reducer");
var _middleware = require("./store/middleware");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Internally, our state is sometimes immutable, ignore that in our external
 * interface.
 */

/**
 * Internally, we use `ImmutableReducer`, but we present a regular reducer
 * externally for compatibility w/ regular redux.
 */

class Management {
  setup() {}
  start(core, plugins) {
    return {
      routes: _routes.routes,
      store: {
        initialState: {
          /**
           * Cast the state to ManagementState for compatibility with
           * the subplugin architecture (which expects initialize state.)
           * but you do not need it because this plugin is doing it through its middleware
           */
          management: {}
        },
        /**
         * Cast the ImmutableReducer to a regular reducer for compatibility with
         * the subplugin architecture (which expects plain redux reducers.)
         */
        reducer: {
          management: _reducer.managementReducer
        },
        middleware: (0, _middleware.managementMiddlewareFactory)(core, plugins)
      }
    };
  }
}
exports.Management = Management;