"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeviceControlSettingCardSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _types = require("../../../../../../../common/endpoint/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/device_control_setting_card_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeviceControlSettingCardSwitch = exports.DeviceControlSettingCardSwitch = /*#__PURE__*/_react.default.memo(({
  protectionLabel,
  osList,
  onChange,
  policy,
  mode,
  selected,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isEditMode = mode === 'edit';
  const handleSwitchChange = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    if (event.target.checked === false) {
      var _newPayload$windows$p, _newPayload$mac$popup;
      // Disable device control for Windows and Mac
      newPayload.windows.device_control = {
        enabled: false,
        usb_storage: _types.DeviceControlAccessLevel.audit
      };
      newPayload.windows.popup.device_control = {
        enabled: false,
        message: ((_newPayload$windows$p = newPayload.windows.popup.device_control) === null || _newPayload$windows$p === void 0 ? void 0 : _newPayload$windows$p.message) || ''
      };
      newPayload.mac.device_control = {
        enabled: false,
        usb_storage: _types.DeviceControlAccessLevel.audit
      };
      newPayload.mac.popup.device_control = {
        enabled: false,
        message: ((_newPayload$mac$popup = newPayload.mac.popup.device_control) === null || _newPayload$mac$popup === void 0 ? void 0 : _newPayload$mac$popup.message) || ''
      };
    } else {
      var _newPayload$windows$p2, _newPayload$mac$popup2;
      // Enable device control for Windows and Mac
      newPayload.windows.device_control = {
        enabled: true,
        usb_storage: _types.DeviceControlAccessLevel.deny_all
      };
      newPayload.windows.popup = newPayload.windows.popup || {};
      newPayload.windows.popup.device_control = {
        enabled: true,
        message: ((_newPayload$windows$p2 = newPayload.windows.popup.device_control) === null || _newPayload$windows$p2 === void 0 ? void 0 : _newPayload$windows$p2.message) || ''
      };
      newPayload.mac.device_control = {
        enabled: true,
        usb_storage: _types.DeviceControlAccessLevel.deny_all
      };
      newPayload.mac.popup = newPayload.mac.popup || {};
      newPayload.mac.popup.device_control = {
        enabled: true,
        message: ((_newPayload$mac$popup2 = newPayload.mac.popup.device_control) === null || _newPayload$mac$popup2 === void 0 ? void 0 : _newPayload$mac$popup2.message) || ''
      };
    }
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [policy, onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: protectionLabel,
    labelProps: {
      'data-test-subj': getTestId('label')
    },
    checked: selected,
    disabled: !isEditMode,
    onChange: handleSwitchChange,
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  });
});
DeviceControlSettingCardSwitch.displayName = 'DeviceControlSettingCardSwitch';