"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERTS_CARD_ITEMS_BY_ID = exports.ALERTS_CARD_ITEMS = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("./types");
var _types2 = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_CARD_ITEMS = exports.ALERTS_CARD_ITEMS = [{
  id: _types.AlertsCardItemId.list,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.details.title', {
    defaultMessage: 'Alert list and details'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.details.description', {
    defaultMessage: 'Sort through alerts and drill down into its details'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: '//play.vidyard.com/evxFZ8dqfjH6SGPtRriyE6',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.details.description', {
      defaultMessage: 'Sort through alerts and drill down into its details'
    })
  }
}, {
  id: _types.AlertsCardItemId.timeline,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.timeline.title', {
    defaultMessage: 'Investigate in Timeline'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.timeline.description', {
    defaultMessage: 'Streamline alert investigation with real-time visualization'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: '//play.vidyard.com/nXC8MSkzDBWajoXWJ3QeQp',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.timeline.description', {
      defaultMessage: 'Streamline alert investigation with real-time visualization'
    })
  }
}, {
  id: _types.AlertsCardItemId.analyzer,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.analyzer.title', {
    defaultMessage: 'Investigate in Analyzer'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.analyzer.description', {
    defaultMessage: 'Simplify alert analysis by visualizing threat detection processes'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: '//play.vidyard.com/VSvxJeSQzrFN9K6hdeLz58',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.analyzer.description', {
      defaultMessage: 'Simplify alert analysis by visualizing threat detection processes'
    })
  }
}, {
  id: _types.AlertsCardItemId.sessionView,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.sessionView.title', {
    defaultMessage: 'Investigate in Session View'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.sessionView.description', {
    defaultMessage: 'Centralized threat analysis and response with real-time data insights'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: '//play.vidyard.com/3TNBvcisQWFKTcmbyprmrU',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.alertsCards.sessionView.description', {
      defaultMessage: 'Centralized threat analysis and response with real-time data insights'
    })
  }
}];
const ALERTS_CARD_ITEMS_BY_ID = exports.ALERTS_CARD_ITEMS_BY_ID = Object.fromEntries(ALERTS_CARD_ITEMS.map(card => [card.id, card]));