"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class OnboardingService {
  constructor() {
    (0, _defineProperty2.default)(this, "usersUrlSubject$", void 0);
    (0, _defineProperty2.default)(this, "usersUrl$", void 0);
    (0, _defineProperty2.default)(this, "isAgentlessAvailableSubject$", void 0);
    (0, _defineProperty2.default)(this, "isAgentlessAvailable$", void 0);
    (0, _defineProperty2.default)(this, "projectUrlSubject$", void 0);
    (0, _defineProperty2.default)(this, "projectUrl$", void 0);
    (0, _defineProperty2.default)(this, "deploymentUrlSubject$", void 0);
    (0, _defineProperty2.default)(this, "deploymentUrl$", void 0);
    this.usersUrlSubject$ = new _rxjs.BehaviorSubject(undefined);
    this.usersUrl$ = this.usersUrlSubject$.asObservable();
    this.isAgentlessAvailableSubject$ = new _rxjs.BehaviorSubject(undefined);
    this.isAgentlessAvailable$ = this.isAgentlessAvailableSubject$.asObservable();
    this.projectUrlSubject$ = new _rxjs.BehaviorSubject(undefined);
    this.projectUrl$ = this.projectUrlSubject$.asObservable();
    this.deploymentUrlSubject$ = new _rxjs.BehaviorSubject(undefined);
    this.deploymentUrl$ = this.deploymentUrlSubject$.asObservable();
  }
  setSettings({
    userUrl,
    isAgentlessAvailable,
    projectUrl,
    deploymentUrl
  }) {
    this.usersUrlSubject$.next(userUrl);
    this.isAgentlessAvailableSubject$.next(isAgentlessAvailable);
    this.projectUrlSubject$.next(projectUrl);
    this.deploymentUrlSubject$.next(deploymentUrl);
  }
}
exports.OnboardingService = OnboardingService;