"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UP = exports.TIME_SAVED_DESC = exports.TIME_SAVED = exports.TIME_RANGE = exports.THREATS_DETECTED = exports.STAT_DIFFERENCE = exports.NO_CHANGE = exports.NON_SUSPICIOUS_ALERTS = exports.MINIMIZE_ALERT_FATIGUE = exports.LEGAL_DISCLAIMER = exports.KEY_INSIGHT = exports.INSIGHTS_ERROR = exports.FILTERING_RATE = exports.FILTERED_ALERTS_2 = exports.FILTERED_ALERTS_1 = exports.EXPORT_REPORT = exports.EXECUTIVE_SUMMARY_SUBTITLE = exports.EXECUTIVE_SUMMARY_SECONDARY_TEXT = exports.EXECUTIVE_SUMMARY_MAIN_TEXT = exports.EXECUTIVE_SAVINGS_SUMMARY = exports.EXECUTIVE_MESSAGE_NO_ATTACKS = exports.ESCALATED_RATE = exports.ESCALATED_ALERTS_2 = exports.ESCALATED_ALERTS_1 = exports.ESCALATED_ALERTS = exports.ESCALATED = exports.EDIT_TITLE = exports.DOWN = exports.COST_SAVINGS_TREND = exports.COST_CALCULATIONS = exports.COST_CALCULATION = exports.COMPARED = exports.CHANGE_RATE = exports.ATTACK_DISCOVERY_COUNT = exports.ALERT_PROCESSING_TITLE = exports.AI_FILTERED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UP = exports.UP = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.up', {
  defaultMessage: 'up'
});
const DOWN = exports.DOWN = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.down', {
  defaultMessage: 'down'
});
const COST_SAVINGS_TREND = exports.COST_SAVINGS_TREND = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.costSavingsTrend', {
  defaultMessage: 'Cost savings trend'
});
const INSIGHTS_ERROR = exports.INSIGHTS_ERROR = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.insightsError', {
  defaultMessage: 'Failed to fetch insight data due to an error:'
});
const NO_CHANGE = statType => _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.noChange', {
  defaultMessage: 'Your {statType} is unchanged',
  values: {
    statType
  }
});
exports.NO_CHANGE = NO_CHANGE;
const STAT_DIFFERENCE = ({
  upOrDown,
  percentageChange,
  stat,
  statType
}) => _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.timeDifference', {
  defaultMessage: `Your {statType} is {upOrDown} by {percentageChange} from {stat}`,
  values: {
    upOrDown,
    percentageChange,
    stat,
    statType
  }
});
exports.STAT_DIFFERENCE = STAT_DIFFERENCE;
const TIME_RANGE = timeRange => _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.timeRange', {
  defaultMessage: 'over the last {timeRange} days',
  values: {
    timeRange
  }
});
exports.TIME_RANGE = TIME_RANGE;
const ATTACK_DISCOVERY_COUNT = exports.ATTACK_DISCOVERY_COUNT = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.attackDiscoveryCount', {
  defaultMessage: 'attack discovery count'
});
const EXPORT_REPORT = exports.EXPORT_REPORT = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.exportReport', {
  defaultMessage: 'Export report'
});
const FILTERING_RATE = exports.FILTERING_RATE = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.filteringRate', {
  defaultMessage: 'Alert filtering rate'
});
const COMPARED = exports.COMPARED = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.compared', {
  defaultMessage: 'Compared to the previous period:'
});
const NON_SUSPICIOUS_ALERTS = exports.NON_SUSPICIOUS_ALERTS = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.falsePositives', {
  defaultMessage: 'Non-suspicious alerts'
});
const ESCALATED = exports.ESCALATED = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.escalated', {
  defaultMessage: 'Escalated'
});
const ESCALATED_ALERTS = exports.ESCALATED_ALERTS = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.escalatedAlerts', {
  defaultMessage: 'Escalated alerts'
});
const ESCALATED_RATE = exports.ESCALATED_RATE = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.escalatedRate', {
  defaultMessage: 'Escalated alert rate'
});
const TIME_SAVED = exports.TIME_SAVED = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.timeSavedTitle', {
  defaultMessage: 'Analyst time saved'
});
const TIME_SAVED_DESC = exports.TIME_SAVED_DESC = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.timeSavedTitle', {
  defaultMessage: 'Time saved in hours'
});
const ALERT_PROCESSING_TITLE = exports.ALERT_PROCESSING_TITLE = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.alertProcessingTitle', {
  defaultMessage: 'Alert processing analytics'
});
const EXECUTIVE_MESSAGE_NO_ATTACKS = exports.EXECUTIVE_MESSAGE_NO_ATTACKS = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.executiveMessageNoAttacks', {
  defaultMessage: 'There are no attack discoveries in the selected time range. Update your time range to include attack discoveries, or visit the attack discovery page to start generating attacks.'
});
const THREATS_DETECTED = exports.THREATS_DETECTED = _i18n.i18n.translate('xpack.securitySolution.aiValue.threatsDetectedTitle', {
  defaultMessage: 'Real threats detected'
});
const KEY_INSIGHT = exports.KEY_INSIGHT = _i18n.i18n.translate('xpack.securitySolution.aiValue.keyInsight', {
  defaultMessage: 'Key Insight'
});
const MINIMIZE_ALERT_FATIGUE = exports.MINIMIZE_ALERT_FATIGUE = _i18n.i18n.translate('xpack.securitySolution.aiValue.minimizeFatigue', {
  defaultMessage: 'Elastic’s Attack Discovery is effectively minimizing alert fatigue by filtering out the vast majority of noise, only escalating credible threats, and maintaining a very low false positive rate. This allows security teams to spend their time on true investigations instead of sifting through irrelevant alerts'
});
const FILTERED_ALERTS_1 = ({
  percentage,
  count
}) => _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.filteredAlerts1', {
  defaultMessage: 'High automation efficiency: {percentage} of alerts ({count})',
  values: {
    percentage,
    count
  }
});
exports.FILTERED_ALERTS_1 = FILTERED_ALERTS_1;
const FILTERED_ALERTS_2 = exports.FILTERED_ALERTS_2 = _i18n.i18n.translate('xpack.securitySolution.aiValue.filteredAlerts2', {
  defaultMessage: ' were automatically filtered out by AI, meaning analysts didn’t have to review them manually. This drastically cuts down noise and routine triage work'
});
const ESCALATED_ALERTS_1 = ({
  percentage,
  count
}) => _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.escalatedAlerts1', {
  defaultMessage: 'Focused escalations: Only {percentage} of alerts ({count})',
  values: {
    percentage,
    count
  }
});
exports.ESCALATED_ALERTS_1 = ESCALATED_ALERTS_1;
const ESCALATED_ALERTS_2 = exports.ESCALATED_ALERTS_2 = _i18n.i18n.translate('xpack.securitySolution.aiValue.escalatedAlerts2', {
  defaultMessage: ' were escalated for analyst review — highlighting that Elastic’s Attack Discovery surfaces only the alerts that matter and are more likely tied to actual threats'
});
const AI_FILTERED = exports.AI_FILTERED = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.aiFiltered', {
  defaultMessage: 'AI filtered'
});
const COST_CALCULATIONS = exports.COST_CALCULATIONS = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.costCalculations', {
  defaultMessage: 'Cost calculations'
});
const COST_CALCULATION = ({
  minutesPerAlert,
  analystHourlyRate
}) => _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.costCalculation', {
  defaultMessage: 'Value is calculated by multiplying the total number of alerts by {minutesPerAlert} minutes each and then multiplying the result by a ${analystHourlyRate} per hour analyst rate.',
  values: {
    minutesPerAlert,
    analystHourlyRate
  }
});
exports.COST_CALCULATION = COST_CALCULATION;
const CHANGE_RATE = exports.CHANGE_RATE = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.changeRate', {
  defaultMessage: 'Change rate in advanced settings'
});
const EDIT_TITLE = exports.EDIT_TITLE = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.editTitle', {
  defaultMessage: 'Edit title inline'
});
const LEGAL_DISCLAIMER = exports.LEGAL_DISCLAIMER = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.legalDisclaimer', {
  defaultMessage: 'The savings, figures, and estimates presented herein are for illustrative and informational purposes only. Individual results may vary significantly. This information is not, and should not be taken as, legal or financial advice to any person or company. Before making any decisions, consult with a qualified advisor. Elastic accepts no liability or responsibility whatsoever for any losses or liabilities allegedly arising from the use of this information.'
});
const EXECUTIVE_SUMMARY_SUBTITLE = exports.EXECUTIVE_SUMMARY_SUBTITLE = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.executiveSummarySubtitle', {
  defaultMessage: 'Elastic AI SOC Engine continues to deliver measurable ROI: '
});
const EXECUTIVE_SAVINGS_SUMMARY = ({
  costSavings,
  hoursSaved
}) => _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.executiveSavingsSummary', {
  defaultMessage: '{costSavings} cost savings and {hoursSaved} analyst hours saved',
  values: {
    costSavings,
    hoursSaved
  }
});
exports.EXECUTIVE_SAVINGS_SUMMARY = EXECUTIVE_SAVINGS_SUMMARY;
const EXECUTIVE_SUMMARY_MAIN_TEXT = ({
  timeRange,
  minutesPerAlert,
  analystRate
}) => _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.executiveSummaryMainText', {
  defaultMessage: ' over the last {timeRange} days — significantly increasing threat detection coverage. These results are based on automating alert triage, using an average review time of {minutesPerAlert} minutes per alert and a ${analystRate}/hour analyst rate.',
  values: {
    timeRange,
    minutesPerAlert,
    analystRate
  }
});
exports.EXECUTIVE_SUMMARY_MAIN_TEXT = EXECUTIVE_SUMMARY_MAIN_TEXT;
const EXECUTIVE_SUMMARY_SECONDARY_TEXT = exports.EXECUTIVE_SUMMARY_SECONDARY_TEXT = _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.executiveSummarySecondaryText', {
  defaultMessage: 'By reducing the manual burden of high-volume alert review, the AI SOC enhances efficiency, lowers operational costs, and enables teams to focus on higher-value security work. At the same time, it increases threat detection coverage — helping organizations respond faster, with fewer resources.'
});