"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.START_DASHBOARDS_MIGRATION_DIALOG_TITLE = exports.START_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION = exports.RETRY_DASHBOARDS_MIGRATION_DIALOG_TITLE = exports.RETRY_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION = exports.REPROCESS_DASHBOARDS_MIGRATION_DIALOG_TITLE = exports.REPROCESS_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const START_DASHBOARDS_MIGRATION_DIALOG_TITLE = exports.START_DASHBOARDS_MIGRATION_DIALOG_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.startMigrationDialog.title', {
  defaultMessage: 'Migrate dashboards'
});
const START_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION = exports.START_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.startMigrationDialog.description', {
  defaultMessage: 'You are about to start a migration. Select which AI connector to use.'
});
const RETRY_DASHBOARDS_MIGRATION_DIALOG_TITLE = exports.RETRY_DASHBOARDS_MIGRATION_DIALOG_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.retryMigrationDialog.title', {
  defaultMessage: 'Retry dashboards migration'
});
const RETRY_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION = exports.RETRY_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.retryMigrationDialog.description', {
  defaultMessage: 'You are about to retry a migration, which will use additional tokens. Select which AI connector to use.'
});
const REPROCESS_DASHBOARDS_MIGRATION_DIALOG_TITLE = count => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.reprocessDialog.title', {
  defaultMessage: 'Reprocess {count} {count, plural, one {dashboard} other {dashboards}}',
  values: {
    count
  }
});
exports.REPROCESS_DASHBOARDS_MIGRATION_DIALOG_TITLE = REPROCESS_DASHBOARDS_MIGRATION_DIALOG_TITLE;
const REPROCESS_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION = exports.REPROCESS_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.reprocessDialog.description', {
  defaultMessage: 'You are about to reprocess a migration, which will use additional tokens. Select which AI connector to use.'
});