"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStartDashboardsMigrationModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_is_open_state = require("../../../common/hooks/use_is_open_state");
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../../common/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/hooks/use_start_dashboard_migration_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStartDashboardsMigrationModal = ({
  type,
  migrationStats,
  translationStats,
  onStartMigrationWithSettings
}) => {
  var _migrationStats$last_2;
  const {
    isOpen: isModalVisible,
    open: showModal,
    close: closeModal
  } = (0, _use_is_open_state.useIsOpenState)(false);
  const defaultSettingsForModal = (0, _react.useMemo)(() => {
    var _migrationStats$last_;
    return {
      connectorId: migrationStats === null || migrationStats === void 0 ? void 0 : (_migrationStats$last_ = migrationStats.last_execution) === null || _migrationStats$last_ === void 0 ? void 0 : _migrationStats$last_.connector_id
    };
  }, [migrationStats === null || migrationStats === void 0 ? void 0 : (_migrationStats$last_2 = migrationStats.last_execution) === null || _migrationStats$last_2 === void 0 ? void 0 : _migrationStats$last_2.connector_id]);
  const title = (0, _react.useMemo)(() => {
    var _translationStats$das;
    switch (type) {
      case 'start':
        return i18n.START_DASHBOARDS_MIGRATION_DIALOG_TITLE;
      case 'retry':
        return i18n.RETRY_DASHBOARDS_MIGRATION_DIALOG_TITLE;
      case 'reprocess':
        return i18n.REPROCESS_DASHBOARDS_MIGRATION_DIALOG_TITLE((_translationStats$das = translationStats === null || translationStats === void 0 ? void 0 : translationStats.dashboards.failed) !== null && _translationStats$das !== void 0 ? _translationStats$das : 0);
    }
  }, [translationStats === null || translationStats === void 0 ? void 0 : translationStats.dashboards.failed, type]);
  const description = (0, _react.useMemo)(() => {
    switch (type) {
      case 'start':
        return i18n.START_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION;
      case 'retry':
        return i18n.RETRY_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION;
      case 'reprocess':
        return i18n.REPROCESS_DASHBOARDS_MIGRATION_DIALOG_DESCRIPTION;
    }
  }, [type]);
  const modal = (0, _react.useMemo)(() => {
    if (!isModalVisible) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_components.StartMigrationModal, {
      title: title,
      description: description,
      defaultSettings: defaultSettingsForModal,
      onStartMigrationWithSettings: onStartMigrationWithSettings,
      onClose: closeModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    });
  }, [closeModal, defaultSettingsForModal, description, isModalVisible, onStartMigrationWithSettings, title]);
  return {
    modal,
    showModal,
    closeModal
  };
};
exports.useStartDashboardsMigrationModal = useStartDashboardsMigrationModal;