"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateMigration = exports.DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_SUCCESS_TITLE = exports.DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION = exports.DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_ERROR = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _service = require("../../../common/service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_SUCCESS_TITLE = exports.DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.service.createDashboardSuccess.title', {
  defaultMessage: 'Dashboard migration created successfully'
});
const DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION = dashboards => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.service.createDashboardSuccess.description', {
  defaultMessage: '{dashboards} dashboards uploaded',
  values: {
    dashboards
  }
});
exports.DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION = DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION;
const DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_ERROR = exports.DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.service.createDashboardError', {
  defaultMessage: 'Failed to upload dashboards file'
});
const useCreateMigration = onSuccess => {
  const {
    siemMigrations,
    notifications
  } = (0, _kibana_react.useKibana)().services;
  const [state, dispatch] = (0, _react.useReducer)(_service.reducer, _service.initialState);
  const createMigration = (0, _react.useCallback)((migrationName, dashboards) => {
    (async () => {
      try {
        dispatch({
          type: 'start'
        });
        const migrationId = await siemMigrations.dashboards.createDashboardMigration(dashboards, migrationName);
        const stats = await siemMigrations.dashboards.api.getDashboardMigrationStats({
          migrationId
        });
        notifications.toasts.addSuccess({
          title: DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_SUCCESS_TITLE,
          text: DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION(dashboards.length)
        });
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(stats);
        dispatch({
          type: 'success'
        });
      } catch (err) {
        var _err$body;
        const apiError = (_err$body = err.body) !== null && _err$body !== void 0 ? _err$body : err;
        notifications.toasts.addError(apiError, {
          title: DASHBOARDS_DATA_INPUT_CREATE_MIGRATION_ERROR
        });
        dispatch({
          type: 'error',
          error: apiError
        });
      }
    })();
  }, [siemMigrations.dashboards, notifications.toasts, onSuccess]);
  return {
    isLoading: state.loading,
    error: state.error,
    createMigration
  };
};
exports.useCreateMigration = useCreateMigration;