"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.translatePaginationStatus = exports.INSPECT_BUTTON_TITLE = exports.DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.threatIntelligence.indicatorNameFieldDescription', {
  defaultMessage: 'Indicator display name generated in the runtime '
});
const INSPECT_BUTTON_TITLE = exports.INSPECT_BUTTON_TITLE = _i18n.i18n.translate('xpack.securitySolution.threatIntelligence.inspectTitle', {
  defaultMessage: 'Inspect'
});
const translatePaginationStatus = ({
  start,
  indicatorCount,
  end
}) => _i18n.i18n.translate('xpack.securitySolution.threatIntelligence.paginationStatus', {
  defaultMessage: `Showing {start}-{end} of {indicatorCount} indicators`,
  values: {
    start: start + 1,
    end: end > indicatorCount ? indicatorCount : end,
    indicatorCount
  }
});
exports.translatePaginationStatus = translatePaginationStatus;