"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicatorsFlyoutContext = exports.IndicatorsFlyoutContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicatorsFlyoutContext = exports.IndicatorsFlyoutContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * Hook to retrieve {@link IndicatorsFiltersContext} (contains FilterManager)
 */
const useIndicatorsFlyoutContext = () => {
  const contextValue = (0, _react.useContext)(IndicatorsFlyoutContext);
  if (!contextValue) {
    throw new Error('IndicatorsFlyoutContext can only be used within IndicatorsFlyoutContext provider');
  }
  return contextValue;
};
exports.useIndicatorsFlyoutContext = useIndicatorsFlyoutContext;