"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CancelButton = exports.AddNote = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _app = require("../../../../common/store/app");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _new_note = require("./new_note");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/notes/add_note/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddNotesContainer = _styledComponents.default.div`
  margin-bottom: 5px;
  user-select: none;
`;
AddNotesContainer.displayName = 'AddNotesContainer';
const ButtonsContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-top: ${({
  theme
}) => theme.eui.euiSizeS};
`;
ButtonsContainer.displayName = 'ButtonsContainer';
const CancelButton = exports.CancelButton = /*#__PURE__*/_react.default.memo(({
  onCancelAddNote
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": "cancel",
  onClick: onCancelAddNote,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 3
  }
}, i18n.CANCEL));
CancelButton.displayName = 'CancelButton';

/** Displays an input for entering a new note, with an adjacent "Add" button */
const AddNote = exports.AddNote = /*#__PURE__*/_react.default.memo(({
  associateNote,
  newNote,
  onCancelAddNote,
  updateNewNote,
  autoFocusDisabled = false
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const authenticatedUser = (0, _kibana.useCurrentUser)();
  const [isMarkdownInvalid, setIsMarkdownInvalid] = (0, _react.useState)(false);
  const updateNote = (0, _react.useCallback)(note => dispatch(_app.appActions.updateNote({
    note
  })), [dispatch]);
  const handleClick = (0, _react.useCallback)(() => {
    const user = authenticatedUser === null || authenticatedUser === void 0 ? void 0 : authenticatedUser.username;
    if (user) {
      (0, _helpers.updateAndAssociateNode)({
        associateNote,
        newNote,
        updateNewNote,
        updateNote,
        user
      });
    }
  }, [associateNote, newNote, updateNewNote, updateNote, authenticatedUser]);
  const onKeyDown = (0, _react.useCallback)(e => {
    // when editing notes, the row-level keyboard handlers shall not
    // receive keyboard events
    e.stopPropagation();
    if (e.key === 'Escape' && onCancelAddNote != null) {
      onCancelAddNote();
    }
  }, [onCancelAddNote]);
  const isAddNoteDisabled = (0, _react.useMemo)(() => {
    return newNote.trim().length === 0 || isMarkdownInvalid;
  }, [newNote, isMarkdownInvalid]);
  return /*#__PURE__*/_react.default.createElement(AddNotesContainer, {
    onKeyDown: onKeyDown,
    role: "dialog",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "screenReaderOnly",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, i18n.YOU_ARE_EDITING_A_NOTE)), /*#__PURE__*/_react.default.createElement(_new_note.NewNote, {
    note: newNote,
    noteInputHeight: 200,
    updateNewNote: updateNewNote,
    autoFocusDisabled: autoFocusDisabled,
    setIsMarkdownInvalid: setIsMarkdownInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(ButtonsContainer, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, onCancelAddNote != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CancelButton, {
    onCancelAddNote: onCancelAddNote,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "add-note",
    isDisabled: isAddNoteDisabled,
    fill: true,
    onClick: handleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, i18n.ADD_NOTE)))));
});
AddNote.displayName = 'AddNote';