"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStatefulEventFocus = exports.getSameOrNextAriaRowindex = void 0;
var _react = require("react");
var _public = require("@kbn/timelines-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSameOrNextAriaRowindex = ({
  ariaRowindex,
  event
}) => (0, _public.isArrowUp)(event) ? ariaRowindex : ariaRowindex + 1;
exports.getSameOrNextAriaRowindex = getSameOrNextAriaRowindex;
const useStatefulEventFocus = ({
  ariaRowindex,
  colindexAttribute,
  containerRef,
  lastFocusedAriaColindex,
  onColumnFocused,
  rowindexAttribute
}) => {
  const [focusOwnership, setFocusOwnership] = (0, _react.useState)('not-owned');
  const onFocus = (0, _react.useCallback)(() => {
    setFocusOwnership(prevFocusOwnership => {
      if (prevFocusOwnership !== 'owned') {
        return 'owned';
      }
      return prevFocusOwnership;
    });
  }, []);
  const onOutsideClick = (0, _react.useCallback)(() => {
    setFocusOwnership('not-owned');
  }, []);
  const onKeyDown = (0, _react.useCallback)(e => {
    if ((0, _public.isArrowDownOrArrowUp)(e) || (0, _public.isEscape)(e)) {
      e.preventDefault();
      e.stopPropagation();
      setFocusOwnership('not-owned');
      const newAriaRowindex = (0, _public.isEscape)(e) ? ariaRowindex // return focus to the same row
      : getSameOrNextAriaRowindex({
        ariaRowindex,
        event: e
      });
      setTimeout(() => {
        onColumnFocused((0, _public.focusColumn)({
          ariaColindex: lastFocusedAriaColindex,
          ariaRowindex: newAriaRowindex,
          colindexAttribute,
          containerElement: containerRef.current,
          rowindexAttribute
        }));
      }, 0);
    }
  }, [ariaRowindex, colindexAttribute, containerRef, lastFocusedAriaColindex, onColumnFocused, rowindexAttribute]);
  const memoizedReturn = (0, _react.useMemo)(() => ({
    focusOwnership,
    onFocus,
    onOutsideClick,
    onKeyDown
  }), [focusOwnership, onFocus, onKeyDown, onOutsideClick]);
  return memoizedReturn;
};
exports.useStatefulEventFocus = useStatefulEventFocus;