"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TimelineResizableLayoutComponent = exports.TimelineResizableLayout = exports.SIDEBAR_WIDTH_KEY = void 0;
var _eui = require("@elastic/eui");
var _resizableLayout = require("@kbn/resizable-layout");
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/unified_components/resizable_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SIDEBAR_WIDTH_KEY = exports.SIDEBAR_WIDTH_KEY = 'timeline:sidebarWidth';

// TODO: This is almost a duplicate of the logic here: src/plugins/discover/public/application/main/components/layout/discover_resizable_layout.tsx
// Should this layout be a shared package or just an accepted dupe since the <ResizeableLayout /> is already shared?

const TimelineResizableLayoutComponent = ({
  sidebarPanel,
  mainPanel,
  unifiedFieldListSidebarContainerApi
}) => {
  var _unifiedFieldListSide;
  const [sidebarPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight sidebarPanel'
    }
  }));
  const [mainPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight mainPanel'
    }
  }));
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const minSidebarWidth = euiTheme.base * 13;
  const defaultSidebarWidth = euiTheme.base * 19;
  const minMainPanelWidth = euiTheme.base * 30;
  const [sidebarWidth, setSidebarWidth] = (0, _useLocalStorage.default)(SIDEBAR_WIDTH_KEY, defaultSidebarWidth);
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const isSidebarCollapsed = (0, _useObservable.default)((_unifiedFieldListSide = unifiedFieldListSidebarContainerApi === null || unifiedFieldListSidebarContainerApi === void 0 ? void 0 : unifiedFieldListSidebarContainerApi.sidebarVisibility.isCollapsed$) !== null && _unifiedFieldListSide !== void 0 ? _unifiedFieldListSide : (0, _rxjs.of)(true), true);
  const layoutMode = isMobile || isSidebarCollapsed ? _resizableLayout.ResizableLayoutMode.Static : _resizableLayout.ResizableLayoutMode.Resizable;
  const layoutDirection = isMobile ? _resizableLayout.ResizableLayoutDirection.Vertical : _resizableLayout.ResizableLayoutDirection.Horizontal;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: sidebarPanelNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, sidebarPanel), /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: mainPanelNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, mainPanel), /*#__PURE__*/_react.default.createElement(_resizableLayout.ResizableLayout, {
    className: "timelineUnifiedComponentsBody__contents",
    mode: layoutMode,
    direction: layoutDirection,
    fixedPanelSize: sidebarWidth !== null && sidebarWidth !== void 0 ? sidebarWidth : defaultSidebarWidth,
    minFixedPanelSize: minSidebarWidth,
    minFlexPanelSize: minMainPanelWidth,
    fixedPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: sidebarPanelNode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 21
      }
    }),
    flexPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: mainPanelNode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 20
      }
    }),
    resizeButtonClassName: "timelineSidebarResizeButton",
    "data-test-subj": "timelineUnifiedComponentsLayout",
    onFixedPanelSizeChange: setSidebarWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
};
exports.TimelineResizableLayoutComponent = TimelineResizableLayoutComponent;
const TimelineResizableLayout = exports.default = exports.TimelineResizableLayout = /*#__PURE__*/_react.default.memo(TimelineResizableLayoutComponent);
// eslint-disable-next-line import/no-default-export