"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GENERATE_ESQL_TOOL = void 0;
var _tools = require("@langchain/core/tools");
var _zod = require("@kbn/zod");
var _messages = require("@langchain/core/messages");
var _common = require("../../../../common");
var _common2 = require("./utils/common");
var _generate_esql = require("./graphs/generate_esql/generate_esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOOL_NAME = 'GenerateESQLTool';
const toolDetails = {
  id: 'generate-esql-tool',
  name: TOOL_NAME,
  // note: this description is overwritten when `getTool` is called
  // local definitions exist ../elastic_assistant/server/lib/prompt/tool_prompts.ts
  // local definitions can be overwritten by security-ai-prompt integration definitions
  description: `You MUST use the "${TOOL_NAME}" function when the user wants to:
  - generate an ES|QL query
  - convert queries from another language to ES|QL they can run on their cluster

  ALWAYS use this tool to generate ES|QL queries and never generate ES|QL any other way.`
};
const GENERATE_ESQL_TOOL = exports.GENERATE_ESQL_TOOL = {
  ...toolDetails,
  sourceRegister: _common.APP_UI_ID,
  isSupported: params => {
    const {
      inference,
      connectorId,
      assistantContext,
      createLlmInstance
    } = params;
    return inference != null && connectorId != null && assistantContext != null && createLlmInstance != null;
  },
  async getTool(params) {
    if (!this.isSupported(params)) return null;
    const {
      connectorId,
      inference,
      logger,
      request,
      isOssModel,
      esClient,
      createLlmInstance
    } = params;
    if (inference == null || connectorId == null) return null;
    const selfHealingGraph = await (0, _generate_esql.getGenerateEsqlGraph)({
      esClient,
      connectorId,
      inference,
      logger,
      request,
      createLlmInstance
    });
    return (0, _tools.tool)(async ({
      question
    }) => {
      const result = await selfHealingGraph.invoke({
        messages: [new _messages.HumanMessage({
          content: question
        })],
        input: {
          question
        }
      }, {
        recursionLimit: 30
      });
      const {
        messages
      } = result;
      const lastMessage = messages[messages.length - 1];
      return lastMessage.content;
    }, {
      name: toolDetails.name,
      description: (params.description || toolDetails.description) + (isOssModel ? (0, _common2.getPromptSuffixForOssModel)(TOOL_NAME) : ''),
      schema: _zod.z.object({
        question: _zod.z.string().describe(`The user's exact question about ES|QL. Provide as much detail as possible including the name of the index and fields if the user has provided those.`)
      }),
      tags: ['esql', 'query-generation', 'knowledge-base']
    });
  }
};