"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePolicyAgainstProductFeatures = void 0;
var _keys = require("@kbn/security-solution-features/keys");
var _policy_config_helpers = require("../../../common/endpoint/models/policy_config_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validatePolicyAgainstProductFeatures = (inputs, productFeaturesService) => {
  var _input$config, _input$config$policy;
  const input = inputs.find(i => i.type === 'endpoint');
  const policySettings = input === null || input === void 0 ? void 0 : (_input$config = input.config) === null || _input$config === void 0 ? void 0 : (_input$config$policy = _input$config.policy) === null || _input$config$policy === void 0 ? void 0 : _input$config$policy.value;
  if (policySettings) {
    const globalManifestVersion = policySettings.global_manifest_version;
    if (globalManifestVersion) {
      if (globalManifestVersion !== 'latest' && !productFeaturesService.isEnabled(_keys.ProductFeatureSecurityKey.endpointProtectionUpdates)) {
        const productFeatureError = new Error('To modify protection updates, you must add Endpoint Complete to your project.');
        productFeatureError.statusCode = 403;
        productFeatureError.apiPassThrough = true;
        throw productFeatureError;
      }
    }
    const popupMessagesContainCustomNotifications = (0, _policy_config_helpers.checkIfPopupMessagesContainCustomNotifications)(policySettings);
    if (popupMessagesContainCustomNotifications && !productFeaturesService.isEnabled(_keys.ProductFeatureSecurityKey.endpointCustomNotification)) {
      const productFeatureError = new Error('To customize the user notification, you must add Endpoint Protection Complete to your project.');
      productFeatureError.statusCode = 403;
      productFeatureError.apiPassThrough = true;
      throw productFeatureError;
    }
  }
};
exports.validatePolicyAgainstProductFeatures = validatePolicyAgainstProductFeatures;