"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseEntityTypeAggs = exports.getEntitiesTypeStats = void 0;
var _helper = require("../helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Parses aggregation buckets into a simplified list of entity stats.
 */
const parseEntityTypeAggs = response => {
  return response.buckets.map(bucket => ({
    entity_type: bucket.key,
    doc_count: bucket.doc_count,
    last_doc_timestamp: bucket.last_doc_timestamp.value_as_string
  }));
};

/**
 * Queries Elasticsearch for entity type stats, parses, and returns them.
 */
exports.parseEntityTypeAggs = parseEntityTypeAggs;
const getEntitiesTypeStats = async (esClient, logger) => {
  try {
    var _entityTypeStats$aggr, _entityTypeStats$aggr2, _entityTypeStats$aggr3;
    const isIndexExists = await esClient.indices.exists({
      index: _helper.ENTITY_INDEX
    });
    if (!isIndexExists) {
      logger.debug(`Index ${_helper.ENTITY_INDEX} does not exist.`);
      return [];
    }
    const entityTypeStats = await esClient.search((0, _helper.getAggsQuery)('entity.type', 100));
    const buckets = (_entityTypeStats$aggr = (_entityTypeStats$aggr2 = entityTypeStats.aggregations) === null || _entityTypeStats$aggr2 === void 0 ? void 0 : (_entityTypeStats$aggr3 = _entityTypeStats$aggr2.field_terms) === null || _entityTypeStats$aggr3 === void 0 ? void 0 : _entityTypeStats$aggr3.buckets) !== null && _entityTypeStats$aggr !== void 0 ? _entityTypeStats$aggr : [];
    return parseEntityTypeAggs({
      buckets
    });
  } catch (e) {
    logger.error(`Failed to get entity type stats: ${e instanceof Error ? e.message : String(e)}`);
    return [];
  }
};
exports.getEntitiesTypeStats = getEntitiesTypeStats;