"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetInventoryUsageSchema = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetInventoryUsageSchema = exports.assetInventoryUsageSchema = {
  entities: {
    doc_count: {
      type: 'long'
    },
    last_doc_timestamp: {
      type: 'date'
    }
  },
  entities_type_stats: {
    type: 'array',
    items: {
      entity_type: {
        type: 'keyword'
      },
      doc_count: {
        type: 'long'
      },
      last_doc_timestamp: {
        type: 'date'
      }
    }
  },
  entity_store_stats: {
    type: 'array',
    items: {
      entity_store: {
        type: 'keyword'
      },
      doc_count: {
        type: 'long'
      },
      last_doc_timestamp: {
        type: 'date'
      }
    }
  },
  entity_source_stats: {
    type: 'array',
    items: {
      entity_source: {
        type: 'keyword'
      },
      doc_count: {
        type: 'long'
      },
      last_doc_timestamp: {
        type: 'date'
      }
    }
  },
  asset_criticality_stats: {
    type: 'array',
    items: {
      criticality: {
        type: 'keyword'
      },
      doc_count: {
        type: 'long'
      },
      last_doc_timestamp: {
        type: 'date'
      }
    }
  }
};