"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureInstalledPackage = ensureInstalledPackage;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function ensureInstalledPackage(context, pkgName, pkgVersion, logger) {
  try {
    logger.debug(`ensureInstalledPackage: Ensuring Fleet package is installed: "${pkgName}" v${pkgVersion}`);
    const packageInstallationResult = await context.getInternalFleetServices().packages.ensureInstalledPackage({
      pkgName,
      pkgVersion
    });
    logger.info(`ensureInstalledPackage: Fleet package is ${packageInstallationResult.status}: "${pkgName}" v${pkgVersion}`);
    return packageInstallationResult;
  } catch (error) {
    logger.error(`ensureInstalledPackage: Error ensuring Fleet package is installed: "${pkgName}" v${pkgVersion}}`, error);
    throw error;
  }
}