"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeCommonRuleFields = normalizeCommonRuleFields;
var _transform_actions = require("../../../../../../../common/detection_engine/transform_actions");
var _rule_actions = require("../../../normalization/rule_actions");
var _utils = require("../../../utils/utils");
var _normalize_rule_source = require("./normalize_rule_source");
var _rule_monitoring = require("../../../../rule_monitoring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function normalizeCommonRuleFields(rule) {
  var _rule$systemActions, _rule$updatedBy, _rule$createdBy, _params$relatedIntegr, _params$requiredField, _params$setup, _params$responseActio;
  const params = rule.params;
  const normalizedRuleSource = (0, _normalize_rule_source.normalizeRuleSource)({
    immutable: params.immutable,
    ruleSource: params.ruleSource
  });
  const normalizedInvestigationFields = (0, _utils.migrateLegacyInvestigationFields)(params.investigationFields);
  const alertActions = rule.actions.map(_transform_actions.transformAlertToRuleAction);
  const throttle = (0, _rule_actions.transformFromAlertThrottle)(rule);
  const actions = (0, _rule_actions.transformToActionFrequency)(alertActions, throttle);
  const systemActions = (_rule$systemActions = rule.systemActions) === null || _rule$systemActions === void 0 ? void 0 : _rule$systemActions.map(action => {
    const transformedAction = (0, _transform_actions.transformAlertToRuleSystemAction)(action);
    return transformedAction;
  });
  const executionSummary = (0, _rule_monitoring.createRuleExecutionSummary)(rule);
  return {
    // Basic properties
    id: rule.id,
    rule_id: params.ruleId,
    name: rule.name,
    immutable: params.immutable,
    rule_source: normalizedRuleSource,
    version: params.version,
    revision: rule.revision,
    updated_at: rule.updatedAt.toISOString(),
    updated_by: (_rule$updatedBy = rule.updatedBy) !== null && _rule$updatedBy !== void 0 ? _rule$updatedBy : 'elastic',
    created_at: rule.createdAt.toISOString(),
    created_by: (_rule$createdBy = rule.createdBy) !== null && _rule$createdBy !== void 0 ? _rule$createdBy : 'elastic',
    // Rule schedule and execution-related data
    enabled: rule.enabled,
    interval: rule.schedule.interval,
    from: params.from,
    to: params.to,
    execution_summary: executionSummary !== null && executionSummary !== void 0 ? executionSummary : undefined,
    // Additional information about the rule
    description: params.description,
    tags: rule.tags,
    author: params.author,
    license: params.license,
    threat: params.threat,
    timeline_id: params.timelineId,
    timeline_title: params.timelineTitle,
    investigation_fields: normalizedInvestigationFields,
    related_integrations: (_params$relatedIntegr = params.relatedIntegrations) !== null && _params$relatedIntegr !== void 0 ? _params$relatedIntegr : [],
    required_fields: (_params$requiredField = params.requiredFields) !== null && _params$requiredField !== void 0 ? _params$requiredField : [],
    setup: (_params$setup = params.setup) !== null && _params$setup !== void 0 ? _params$setup : '',
    note: params.note,
    false_positives: params.falsePositives,
    references: params.references,
    // Risk score, severity, and overrides
    risk_score: params.riskScore,
    risk_score_mapping: params.riskScoreMapping,
    severity: params.severity,
    severity_mapping: params.severityMapping,
    rule_name_override: params.ruleNameOverride,
    timestamp_override: params.timestampOverride,
    timestamp_override_fallback_disabled: params.timestampOverrideFallbackDisabled,
    // Rule's detection alerts
    building_block_type: params.buildingBlockType,
    output_index: params.outputIndex,
    namespace: params.namespace,
    max_signals: params.maxSignals,
    // Rule's exceptions
    exceptions_list: params.exceptionsList,
    // Rule's notification and response actions
    throttle: undefined,
    actions: [...actions, ...(systemActions !== null && systemActions !== void 0 ? systemActions : [])],
    response_actions: (_params$responseActio = params.responseActions) === null || _params$responseActio === void 0 ? void 0 : _params$responseActio.map(_transform_actions.transformAlertToRuleResponseAction),
    // Technical fields
    meta: params.meta,
    outcome: isResolvedRule(rule) ? rule.outcome : undefined,
    alias_target_id: isResolvedRule(rule) ? rule.alias_target_id : undefined,
    alias_purpose: isResolvedRule(rule) ? rule.alias_purpose : undefined
  };
}
function isResolvedRule(obj) {
  const outcome = obj.outcome;
  return outcome != null && outcome !== 'exactMatch';
}