"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createThresholdAlertType = void 0;
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../../../../../common/constants");
var _rule_schema = require("../../rule_schema");
var _threshold = require("./threshold");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createThresholdAlertType = () => {
  return {
    id: _securitysolutionRules.THRESHOLD_RULE_TYPE_ID,
    name: 'Threshold Rule',
    validate: {
      params: {
        validate: object => {
          return _rule_schema.ThresholdRuleParams.parse(object);
        },
        /**
         * validate rule params when rule is bulk edited (update and created in future as well)
         * returned params can be modified (useful in case of version increment)
         * @param mutatedRuleParams
         * @returns mutatedRuleParams
         */
        validateMutatedParams: mutatedRuleParams => {
          (0, _utils.validateIndexPatterns)(mutatedRuleParams.index);
          return mutatedRuleParams;
        }
      }
    },
    schemas: {
      params: {
        type: 'zod',
        schema: _rule_schema.ThresholdRuleParams
      }
    },
    actionGroups: [{
      id: 'default',
      name: 'Default'
    }],
    defaultActionGroupId: 'default',
    actionVariables: {
      context: [{
        name: 'server',
        description: 'the server'
      }]
    },
    minimumLicenseRequired: 'basic',
    isExportable: false,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    producer: _constants.SERVER_APP_ID,
    solution: 'security',
    async executor(execOptions) {
      const {
        sharedParams,
        services,
        startedAt,
        state
      } = execOptions;
      const result = await (0, _threshold.thresholdExecutor)({
        sharedParams,
        services,
        startedAt,
        state,
        licensing: sharedParams.licensing,
        scheduleNotificationResponseActionsService: sharedParams.scheduleNotificationResponseActionsService
      });
      return result;
    }
  };
};
exports.createThresholdAlertType = createThresholdAlertType;