"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringEntitySourceDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MonitoringEntitySourceDataClient {
  constructor(opts) {
    (0, _defineProperty2.default)(this, "monitoringEntitySourceClient", void 0);
    this.opts = opts;
    this.monitoringEntitySourceClient = new _saved_objects.MonitoringEntitySourceDescriptorClient({
      soClient: this.opts.soClient,
      namespace: this.opts.namespace
    });
  }
  async init(input) {
    const descriptor = await this.monitoringEntitySourceClient.create({
      ...input
    });
    this.log('debug', 'Initializing MonitoringEntitySourceDataClient Saved Object');
    return descriptor;
  }
  async get(id) {
    this.log('debug', `Getting Monitoring Entity Source Sync saved object with id: ${id}`);
    return this.monitoringEntitySourceClient.get(id);
  }
  async update(update) {
    var _update$matchers;
    this.log('debug', `Updating Monitoring Entity Source Sync saved object with id: ${update.id}`);
    const sanitizedUpdate = {
      ...update,
      matchers: (_update$matchers = update.matchers) === null || _update$matchers === void 0 ? void 0 : _update$matchers.map(matcher => {
        var _matcher$fields, _matcher$values;
        return {
          fields: (_matcher$fields = matcher.fields) !== null && _matcher$fields !== void 0 ? _matcher$fields : [],
          values: (_matcher$values = matcher.values) !== null && _matcher$values !== void 0 ? _matcher$values : []
        };
      })
    };
    return this.monitoringEntitySourceClient.update(sanitizedUpdate);
  }
  async delete(id) {
    this.log('debug', `Deleting Monitoring Entity Source Sync saved object with id: ${id}`);
    return this.monitoringEntitySourceClient.delete(id);
  }
  async list(query) {
    this.log('debug', 'Finding all Monitoring Entity Source Sync saved objects');
    return this.monitoringEntitySourceClient.findAll(query);
  }
  log(level, msg) {
    this.opts.logger[level](`[Monitoring Entity Source Sync][namespace: ${this.opts.namespace}] ${msg}`);
  }
}
exports.MonitoringEntitySourceDataClient = MonitoringEntitySourceDataClient;