"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrivilegeStatusUpdateService = void 0;
var _queries = require("./queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPrivilegeStatusUpdateService = dataClient => {
  const updatePrivilegedStatus = async (users, source) => {
    dataClient.log('debug', `Updating internal index for users ${users.length}`);
    await (0, _queries.applyPrivilegedUpdates)({
      users,
      dataClient,
      source
    });
  };
  return {
    updatePrivilegedStatus
  };
};
exports.createPrivilegeStatusUpdateService = createPrivilegeStatusUpdateService;