"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEngineCrudService = void 0;
var _saved_objects = require("../saved_objects");
var _privilege_monitoring_task = require("../tasks/privilege_monitoring_task");
var _helpers = require("../saved_objects/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEngineCrudService = (dataClient, soClient) => {
  const {
    deps,
    index
  } = dataClient;
  const esClient = deps.clusterClient.asCurrentUser;
  const descriptorClient = new _saved_objects.PrivilegeMonitoringEngineDescriptorClient({
    soClient,
    namespace: deps.namespace
  });
  const _delete = async (deleteData = false) => {
    dataClient.log('info', 'Deleting privilege monitoring engine');
    await descriptorClient.delete().catch(_helpers.ignoreSONotFoundError);
    if (deleteData) {
      await esClient.indices.delete({
        index
      }, {
        ignore: [404]
      });
    }
    if (!deps.taskManager) {
      throw new Error('Task Manager is not available');
    }
    await (0, _privilege_monitoring_task.removePrivilegeMonitoringTask)({
      logger: deps.logger,
      namespace: deps.namespace,
      taskManager: deps.taskManager
    });
    const indexSourceClient = new _saved_objects.MonitoringEntitySourceDescriptorClient({
      namespace: deps.namespace,
      soClient
    });
    const allDataSources = await indexSourceClient.findAll({});
    const deleteSourcePromises = allDataSources.map(so => indexSourceClient.delete(so.id));
    await Promise.all(deleteSourcePromises);
    return {
      deleted: true
    };
  };
  return {
    delete: _delete
  };
};
exports.createEngineCrudService = createEngineCrudService;