"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeMonitoringDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../../../../../common/entity_analytics/privileged_user_monitoring/utils");
var _saved_objects = require("../saved_objects");
var _logger = require("../logger");
var _audit_logger = require("../audit_logger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Privmon data client serves only as a wrapper for plugin/request dependencies and common, global actions
 */
class PrivilegeMonitoringDataClient {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "index", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "auditLogger", void 0);
    this.deps = deps;
    this.index = (0, _utils.getPrivilegedMonitorUsersIndex)(deps.namespace);
    this.deps.experimentalFeatures = deps.experimentalFeatures;
    this.logger = (0, _logger.createPrivMonLogger)(this.deps.logger, this.deps.namespace);
    this.auditLogger = (0, _audit_logger.createPrivMonAuditLogger)(this.deps.auditLogger);
  }
  getScopedSoClient(request, options) {
    var _options$includedHidd;
    const includedHiddenTypes = (_options$includedHidd = options === null || options === void 0 ? void 0 : options.includedHiddenTypes) !== null && _options$includedHidd !== void 0 ? _options$includedHidd : [_saved_objects.monitoringEntitySourceType.name];
    return this.deps.savedObjects.getScopedClient(request, {
      ...options,
      includedHiddenTypes
    });
  }
  log(level, msg) {
    this.logger.log(level, msg);
  }
  audit(action, resource, msg, error) {
    this.auditLogger.log(action, resource, msg, error);
  }
}
exports.PrivilegeMonitoringDataClient = PrivilegeMonitoringDataClient;