"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInitialisationService = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _actions = require("../auditing/actions");
var _constants = require("../constants");
var _events = require("../../../telemetry/event_based/events");
var _indices = require("./elasticsearch/indices");
var _saved_objects = require("../saved_objects");
var _privilege_monitoring_task = require("../tasks/privilege_monitoring_task");
var _initialisation_sources_service = require("./initialisation_sources_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInitialisationService = (dataClient, soClient) => {
  const {
    deps
  } = dataClient;
  const {
    taskManager
  } = deps;
  if (!taskManager) {
    throw new Error('Task Manager is not available');
  }
  const IndexService = (0, _indices.createPrivmonIndexService)(dataClient);
  const init = async () => {
    const descriptorClient = new _saved_objects.PrivilegeMonitoringEngineDescriptorClient({
      soClient,
      namespace: deps.namespace
    });
    const monitoringIndexSourceClient = new _saved_objects.MonitoringEntitySourceDescriptorClient({
      soClient,
      namespace: deps.namespace
    });
    const upsertSources = (0, _initialisation_sources_service.createInitialisationSourcesService)({
      descriptorClient: monitoringIndexSourceClient,
      logger: deps.logger,
      auditLogger: deps.auditLogger
    });
    const setupStartTime = (0, _moment.default)().utc().toISOString();
    dataClient.audit(_actions.PrivilegeMonitoringEngineActions.INIT, _entity_analytics.MonitoringEngineComponentResourceEnum.privmon_engine, 'Initializing privilege monitoring engine');
    const descriptor = await descriptorClient.init();
    dataClient.log('info', `Initialized privileged monitoring engine saved object`);

    // upsert index AND integration sources

    try {
      var _deps$telemetry;
      dataClient.log('debug', 'Upserting privilege monitoring sources');
      await upsertSources(deps.namespace);
      dataClient.log('debug', 'Creating privilege user monitoring event.ingested pipeline');
      await IndexService.initialisePrivmonIndex();
      if (deps.apiKeyManager) {
        await deps.apiKeyManager.generate();
      }
      await (0, _privilege_monitoring_task.startPrivilegeMonitoringTask)({
        taskManager,
        logger: deps.logger,
        namespace: deps.namespace
      });
      const setupEndTime = (0, _moment.default)().utc().toISOString();
      const duration = (0, _moment.default)(setupEndTime).diff((0, _moment.default)(setupStartTime), 'seconds');
      (_deps$telemetry = deps.telemetry) === null || _deps$telemetry === void 0 ? void 0 : _deps$telemetry.reportEvent(_events.PRIVMON_ENGINE_INITIALIZATION_EVENT.eventType, {
        duration
      });
    } catch (e) {
      var _deps$telemetry2;
      dataClient.log('error', `Error initializing privilege monitoring engine: ${e}`);
      dataClient.audit(_actions.PrivilegeMonitoringEngineActions.INIT, _entity_analytics.MonitoringEngineComponentResourceEnum.privmon_engine, 'Failed to initialize privilege monitoring engine', e);
      (_deps$telemetry2 = deps.telemetry) === null || _deps$telemetry2 === void 0 ? void 0 : _deps$telemetry2.reportEvent(_events.PRIVMON_ENGINE_RESOURCE_INIT_FAILURE_EVENT.eventType, {
        error: e.message
      });
      await descriptorClient.update({
        status: _constants.PRIVILEGE_MONITORING_ENGINE_STATUS.ERROR,
        error: {
          message: e.message,
          stack: e.stack,
          action: 'init'
        }
      });
      return {
        status: _constants.PRIVILEGE_MONITORING_ENGINE_STATUS.ERROR,
        error: {
          message: e.message
        }
      };
    }
    return descriptor;
  };
  return {
    init
  };
};
exports.createInitialisationService = createInitialisationService;