"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.healthCheckPrivilegeMonitoringRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _assert_advanced_setting_enabled = require("../../utils/assert_advanced_setting_enabled");
var _status_service = require("../engine/status_service");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const healthCheckPrivilegeMonitoringRoute = (router, logger) => {
  router.versioned.get({
    access: 'public',
    path: _constants.PRIVMON_HEALTH_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const secSol = await context.securitySolution;
    await (0, _assert_advanced_setting_enabled.assertAdvancedSettingsEnabled)(await context.core, _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING);
    const dataClient = secSol.getPrivilegeMonitoringDataClient();
    const soClient = dataClient.getScopedSoClient(request);
    const config = secSol.getConfig();
    const maxUsersAllowed = config.entityAnalytics.monitoring.privileges.users.maxPrivilegedUsersAllowed;
    const statusService = (0, _status_service.createEngineStatusService)(dataClient, soClient);
    try {
      const body = await statusService.get();

      // Only include user count if engine status is "started"
      if (body.status === _constants2.PRIVILEGE_MONITORING_ENGINE_STATUS.STARTED) {
        const userCountResponse = await statusService.getCurrentUserCount();
        return response.ok({
          body: {
            ...body,
            users: {
              current_count: userCountResponse.count,
              max_allowed: maxUsersAllowed
            }
          }
        });
      } else {
        return response.ok({
          body
        });
      }
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error checking privilege monitoring health: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.healthCheckPrivilegeMonitoringRoute = healthCheckPrivilegeMonitoringRoute;