"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemDashboardMigrationsResourceGetMissingRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _dashboard_migration = require("../../../../../../common/siem_migrations/model/api/dashboards/dashboard_migration.gen");
var _constants = require("../../../../../../common/siem_migrations/dashboards/constants");
var _authz = require("../../../common/api/util/authz");
var _with_license = require("../../../common/api/util/with_license");
var _with_existing_migration_id = require("../../../common/api/util/with_existing_migration_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemDashboardMigrationsResourceGetMissingRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_DASHBOARD_MIGRATION_RESOURCES_MISSING_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_dashboard_migration.GetDashboardMigrationResourcesMissingRequestParams)
      }
    }
  }, (0, _with_license.withLicense)((0, _with_existing_migration_id.withExistingMigration)(async (context, req, res) => {
    const migrationId = req.params.migration_id;
    try {
      const ctx = await context.resolve(['securitySolution']);
      const dashboardMigrationsClient = ctx.securitySolution.siemMigrations.getDashboardsClient();
      const options = {
        filters: {
          hasContent: false
        }
      };
      const batches = dashboardMigrationsClient.data.resources.searchBatches(migrationId, options);
      const missingResources = [];
      let results = await batches.next();
      while (results.length) {
        missingResources.push(...results.map(({
          type,
          name
        }) => ({
          type,
          name
        })));
        results = await batches.next();
      }
      return res.ok({
        body: missingResources
      });
    } catch (err) {
      logger.error(err);
      return res.badRequest({
        body: err.message
      });
    }
  })));
};
exports.registerSiemDashboardMigrationsResourceGetMissingRoute = registerSiemDashboardMigrationsResourceGetMissingRoute;