"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSiemMigrationClients = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSiemMigrationClients = (siemMigrationsService, params) => {
  return {
    getRulesClient: (0, _lodash.memoize)(() => siemMigrationsService.createRulesClient(params)),
    getDashboardsClient: (0, _lodash.memoize)(() => siemMigrationsService.createDashboardsClient(params))
  };
};
exports.getSiemMigrationClients = getSiemMigrationClients;