"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsUpdateIndexPatternRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_migration = require("../../../../../common/siem_migrations/model/api/rules/rule_migration.gen");
var _constants = require("../../../../../common/siem_migrations/constants");
var _authz = require("../../common/api/util/authz");
var _with_license = require("../../common/api/util/with_license");
var _with_existing_migration_id = require("../../common/api/util/with_existing_migration_id");
var _audit = require("../../common/api/util/audit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsUpdateIndexPatternRoute = (router, logger) => {
  router.versioned.post({
    path: _constants.SIEM_RULE_MIGRATION_UPDATE_INDEX_PATTERN_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.UpdateRuleMigrationIndexPatternRequestParams),
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.UpdateRuleMigrationIndexPatternRequestBody)
      }
    }
  }, (0, _with_license.withLicense)((0, _with_existing_migration_id.withExistingMigration)(async (context, req, res) => {
    const migrationId = req.params.migration_id;
    const indexPattern = req.body.index_pattern;
    const ids = req.body.ids;
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution, 'rules');
    try {
      const ctx = await context.resolve(['securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.siemMigrations.getRulesClient();
      await siemMigrationAuditLogger.logUpdateRules({
        migrationId,
        ids: ids !== null && ids !== void 0 ? ids : []
      });
      const stats = await ruleMigrationsClient.data.items.updateIndexPattern(migrationId, indexPattern, ids);
      return res.ok({
        body: {
          updated: stats !== null && stats !== void 0 ? stats : 0
        }
      });
    } catch (err) {
      logger.error(err);
      await siemMigrationAuditLogger.logUpdateRules({
        migrationId,
        ids: ids !== null && ids !== void 0 ? ids : [],
        error: err
      });
      return res.badRequest({
        body: err.message
      });
    }
  })));
};
exports.registerSiemRuleMigrationsUpdateIndexPatternRoute = registerSiemRuleMigrationsUpdateIndexPatternRoute;