"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateSemanticQueryNode = void 0;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCreateSemanticQueryNode = ({
  model
}) => {
  const jsonParser = new _output_parsers.JsonOutputParser();
  const semanticQueryChain = _prompts.CREATE_SEMANTIC_QUERY_PROMPT.pipe(model).pipe(jsonParser);
  return async state => {
    const query = state.original_rule.query;
    const integrationQuery = await semanticQueryChain.invoke({
      title: state.original_rule.title,
      description: state.original_rule.description,
      query
    });
    if (!integrationQuery.semantic_query) {
      return {};
    }
    return {
      semantic_query: integrationQuery.semantic_query
    };
  };
};
exports.getCreateSemanticQueryNode = getCreateSemanticQueryNode;