"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.siemMigrationEventNames = exports.SiemMigrationsEventTypes = exports.SIEM_MIGRATIONS_RULE_TRANSLATION_SUCCESS = exports.SIEM_MIGRATIONS_RULE_TRANSLATION_FAILURE = exports.SIEM_MIGRATIONS_PREBUILT_RULES_MATCH = exports.SIEM_MIGRATIONS_MIGRATION_SUCCESS = exports.SIEM_MIGRATIONS_MIGRATION_FAILURE = exports.SIEM_MIGRATIONS_MIGRATION_ABORTED = exports.SIEM_MIGRATIONS_INTEGRATIONS_MATCH = exports.SIEM_MIGRATIONS_EVENTS = exports.SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_SUCCESS = exports.SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_FAILURE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SiemMigrationsEventTypes = exports.SiemMigrationsEventTypes = /*#__PURE__*/function (SiemMigrationsEventTypes) {
  SiemMigrationsEventTypes["MigrationSuccess"] = "siem_migrations_migration_success";
  SiemMigrationsEventTypes["MigrationAborted"] = "siem_migrations_migration_aborted";
  SiemMigrationsEventTypes["MigrationFailure"] = "siem_migrations_migration_failure";
  SiemMigrationsEventTypes["RuleTranslationSuccess"] = "siem_migrations_rule_translation_success";
  SiemMigrationsEventTypes["RuleTranslationFailure"] = "siem_migrations_rule_translation_failure";
  SiemMigrationsEventTypes["RuleTranslationPrebuiltRulesMatch"] = "siem_migrations_prebuilt_rules_match";
  SiemMigrationsEventTypes["RuleTranslationIntegrationsMatch"] = "siem_migrations_integration_match";
  SiemMigrationsEventTypes["DashboardTranslationSuccess"] = "siem_migrations_dashboard_translation_success";
  SiemMigrationsEventTypes["DashboardTranslationFailure"] = "siem_migrations_dashboard_translation_failure";
  return SiemMigrationsEventTypes;
}({});
const siemMigrationEventNames = exports.siemMigrationEventNames = {
  // Common
  [SiemMigrationsEventTypes.MigrationSuccess]: 'Migration success',
  [SiemMigrationsEventTypes.MigrationAborted]: 'Migration aborted',
  [SiemMigrationsEventTypes.MigrationFailure]: 'Migration failure',
  // Rules
  [SiemMigrationsEventTypes.RuleTranslationFailure]: 'Rule translation failure',
  [SiemMigrationsEventTypes.RuleTranslationSuccess]: 'Rule translation success',
  [SiemMigrationsEventTypes.RuleTranslationPrebuiltRulesMatch]: 'Rule translation prebuilt rules match',
  [SiemMigrationsEventTypes.RuleTranslationIntegrationsMatch]: 'Rule translation integrations match',
  // Dashboards
  [SiemMigrationsEventTypes.DashboardTranslationFailure]: 'Dashboard translation failure',
  [SiemMigrationsEventTypes.DashboardTranslationSuccess]: 'Dashboard translation success'
};
const SIEM_MIGRATIONS_MIGRATION_SUCCESS = exports.SIEM_MIGRATIONS_MIGRATION_SUCCESS = {
  eventType: SiemMigrationsEventTypes.MigrationSuccess,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    type: {
      type: 'keyword',
      _meta: {
        description: 'The type of migration, either rules or dashboards'
      }
    },
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration of the migration in milliseconds'
      }
    },
    completed: {
      type: 'long',
      _meta: {
        description: 'Number of rules successfully migrated'
      }
    },
    failed: {
      type: 'long',
      _meta: {
        description: 'Number of rules that failed to migrate'
      }
    },
    total: {
      type: 'long',
      _meta: {
        description: 'Total number of rules to migrate'
      }
    }
  }
};
const SIEM_MIGRATIONS_MIGRATION_FAILURE = exports.SIEM_MIGRATIONS_MIGRATION_FAILURE = {
  eventType: SiemMigrationsEventTypes.MigrationFailure,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    error: {
      type: 'keyword',
      _meta: {
        description: 'Error message for the migration failure'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    type: {
      type: 'keyword',
      _meta: {
        description: 'The type of migration, either rules or dashboards'
      }
    },
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration of the migration in milliseconds'
      }
    },
    completed: {
      type: 'long',
      _meta: {
        description: 'Number of rules successfully migrated'
      }
    },
    failed: {
      type: 'long',
      _meta: {
        description: 'Number of rules that failed to migrate'
      }
    },
    total: {
      type: 'long',
      _meta: {
        description: 'Total number of rules to migrate'
      }
    }
  }
};
const SIEM_MIGRATIONS_MIGRATION_ABORTED = exports.SIEM_MIGRATIONS_MIGRATION_ABORTED = {
  eventType: SiemMigrationsEventTypes.MigrationAborted,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    reason: {
      type: 'keyword',
      _meta: {
        description: 'The reason of the migration abort'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    type: {
      type: 'keyword',
      _meta: {
        description: 'The type of migration, either rules or dashboards'
      }
    },
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration of the migration in milliseconds'
      }
    },
    completed: {
      type: 'long',
      _meta: {
        description: 'Number of rules successfully migrated'
      }
    },
    failed: {
      type: 'long',
      _meta: {
        description: 'Number of rules that failed to migrate'
      }
    },
    total: {
      type: 'long',
      _meta: {
        description: 'Total number of rules to migrate'
      }
    }
  }
};
const SIEM_MIGRATIONS_RULE_TRANSLATION_SUCCESS = exports.SIEM_MIGRATIONS_RULE_TRANSLATION_SUCCESS = {
  eventType: SiemMigrationsEventTypes.RuleTranslationSuccess,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    translationResult: {
      type: 'keyword',
      _meta: {
        description: 'Describes if the translation was full or partial'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration of the migration in milliseconds'
      }
    },
    prebuiltMatch: {
      type: 'boolean',
      _meta: {
        description: 'Whether a prebuilt rule was matched'
      }
    }
  }
};
const SIEM_MIGRATIONS_RULE_TRANSLATION_FAILURE = exports.SIEM_MIGRATIONS_RULE_TRANSLATION_FAILURE = {
  eventType: SiemMigrationsEventTypes.RuleTranslationFailure,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    error: {
      type: 'keyword',
      _meta: {
        description: 'Error message for the translation failure'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    }
  }
};
const SIEM_MIGRATIONS_PREBUILT_RULES_MATCH = exports.SIEM_MIGRATIONS_PREBUILT_RULES_MATCH = {
  eventType: SiemMigrationsEventTypes.RuleTranslationPrebuiltRulesMatch,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    preFilterRuleNames: {
      type: 'array',
      items: {
        type: 'keyword',
        _meta: {
          description: 'List of matched rules from Semantic search before LLM filtering'
        }
      }
    },
    preFilterRuleCount: {
      type: 'long',
      _meta: {
        description: 'Count of rules matched before LLM filtering'
      }
    },
    postFilterRuleName: {
      type: 'keyword',
      _meta: {
        description: 'List of matched rules from Semantic search after LLM filtering'
      }
    },
    postFilterRuleCount: {
      type: 'long',
      _meta: {
        description: 'Count of rules matched before LLM filtering'
      }
    }
  }
};
const SIEM_MIGRATIONS_INTEGRATIONS_MATCH = exports.SIEM_MIGRATIONS_INTEGRATIONS_MATCH = {
  eventType: SiemMigrationsEventTypes.RuleTranslationIntegrationsMatch,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    preFilterIntegrationNames: {
      type: 'array',
      items: {
        type: 'keyword',
        _meta: {
          description: 'List of matched integrations from Semantic search before LLM filtering'
        }
      }
    },
    preFilterIntegrationCount: {
      type: 'long',
      _meta: {
        description: 'Count of integrations matched before LLM filtering'
      }
    },
    postFilterIntegrationName: {
      type: 'keyword',
      _meta: {
        description: 'List of matched integrations from Semantic search after LLM filtering'
      }
    },
    postFilterIntegrationCount: {
      type: 'long',
      _meta: {
        description: 'Count of integrations matched before LLM filtering'
      }
    }
  }
};
const SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_SUCCESS = exports.SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_SUCCESS = {
  eventType: SiemMigrationsEventTypes.DashboardTranslationSuccess,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    translationResult: {
      type: 'keyword',
      _meta: {
        description: 'Describes if the translation was full or partial'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration of the migration in milliseconds'
      }
    }
  }
};
const SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_FAILURE = exports.SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_FAILURE = {
  eventType: SiemMigrationsEventTypes.DashboardTranslationFailure,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    error: {
      type: 'keyword',
      _meta: {
        description: 'Error message for the translation failure'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    }
  }
};
const SIEM_MIGRATIONS_EVENTS = exports.SIEM_MIGRATIONS_EVENTS = [SIEM_MIGRATIONS_MIGRATION_SUCCESS, SIEM_MIGRATIONS_MIGRATION_ABORTED, SIEM_MIGRATIONS_MIGRATION_FAILURE, SIEM_MIGRATIONS_RULE_TRANSLATION_SUCCESS, SIEM_MIGRATIONS_RULE_TRANSLATION_FAILURE, SIEM_MIGRATIONS_PREBUILT_RULES_MATCH, SIEM_MIGRATIONS_INTEGRATIONS_MATCH, SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_SUCCESS, SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_FAILURE];