"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SenderUtils = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _axios = _interopRequireDefault(require("axios"));
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SenderUtils {
  constructor(telemetrySetup, telemetryStart, receiver, telemetryUsageCounter) {
    (0, _defineProperty2.default)(this, "usageLabelPrefix", ['security_telemetry', 'sender']);
    this.telemetrySetup = telemetrySetup;
    this.telemetryStart = telemetryStart;
    this.receiver = receiver;
    this.telemetryUsageCounter = telemetryUsageCounter;
  }
  async fetchSenderMetadata(channel) {
    var _this$receiver, _this$receiver2;
    const [telemetryUrl, licenseInfo] = await Promise.all([this.fetchTelemetryUrl(channel), (_this$receiver = this.receiver) === null || _this$receiver === void 0 ? void 0 : _this$receiver.fetchLicenseInfo()]);
    const clusterInfo = (_this$receiver2 = this.receiver) === null || _this$receiver2 === void 0 ? void 0 : _this$receiver2.getClusterInfo();
    const isTelemetryOptedIn = async () => {
      var _this$telemetryStart;
      return (await ((_this$telemetryStart = this.telemetryStart) === null || _this$telemetryStart === void 0 ? void 0 : _this$telemetryStart.getIsOptedIn())) === true;
    };
    return {
      telemetryUrl,
      licenseInfo,
      clusterInfo,
      telemetryRequestHeaders: () => {
        var _clusterInfo$version;
        const clusterName = clusterInfo === null || clusterInfo === void 0 ? void 0 : clusterInfo.cluster_name;
        const clusterUuid = clusterInfo === null || clusterInfo === void 0 ? void 0 : clusterInfo.cluster_uuid;
        const clusterVersionNumber = clusterInfo === null || clusterInfo === void 0 ? void 0 : (_clusterInfo$version = clusterInfo.version) === null || _clusterInfo$version === void 0 ? void 0 : _clusterInfo$version.number;
        const licenseId = licenseInfo === null || licenseInfo === void 0 ? void 0 : licenseInfo.uid;
        return {
          'Content-Type': 'application/x-ndjson',
          ...(clusterName ? {
            'X-Elastic-Cluster-Name': clusterName
          } : undefined),
          ...(clusterUuid ? {
            'X-Elastic-Cluster-ID': clusterUuid
          } : undefined),
          'X-Elastic-Stack-Version': clusterVersionNumber ? clusterVersionNumber : '8.0.0',
          ...(licenseId ? {
            'X-Elastic-License-ID': licenseId
          } : {})
        };
      },
      isTelemetryOptedIn,
      isTelemetryServicesReachable: async () => {
        const isOptedIn = await isTelemetryOptedIn();
        if (!isOptedIn) {
          return false;
        }
        try {
          const telemetryPingUrl = await this.fetchTelemetryPingUrl();
          const resp = await _axios.default.get(telemetryPingUrl, {
            timeout: 3000
          });
          if (resp.status === 200) {
            return true;
          }
          return false;
        } catch (_) {
          return false;
        }
      }
    };
  }
  incrementCounter(counterType, incrementBy, ...tags) {
    var _this$telemetryUsageC;
    const counterName = (0, _helpers.createUsageCounterLabel)([...this.usageLabelPrefix, ...tags]);
    (_this$telemetryUsageC = this.telemetryUsageCounter) === null || _this$telemetryUsageC === void 0 ? void 0 : _this$telemetryUsageC.incrementCounter({
      counterName,
      counterType,
      incrementBy
    });
  }
  async fetchTelemetryUrl(channel) {
    var _this$telemetrySetup;
    const telemetryUrl = await ((_this$telemetrySetup = this.telemetrySetup) === null || _this$telemetrySetup === void 0 ? void 0 : _this$telemetrySetup.getTelemetryUrl());
    if (!telemetryUrl) {
      throw Error("Couldn't get telemetry URL");
    }
    return this.getV3UrlFromV2(telemetryUrl.toString(), channel);
  }
  async fetchTelemetryPingUrl() {
    var _this$telemetrySetup2;
    const telemetryUrl = await ((_this$telemetrySetup2 = this.telemetrySetup) === null || _this$telemetrySetup2 === void 0 ? void 0 : _this$telemetrySetup2.getTelemetryUrl());
    if (!telemetryUrl) {
      throw Error("Couldn't get telemetry URL");
    }
    telemetryUrl.pathname = `/ping`;
    return telemetryUrl.toString();
  }

  /**
   * This method converts a v2 URL to a v3 URL like:
   *   - https://telemetry.elastic.co/v3/send/my-channel-name
   *   - https://telemetry-staging.elastic.co/v3-dev/send/my-channel-name
   */
  getV3UrlFromV2(v2url, channel) {
    const url = new URL(v2url);
    if (!url.hostname.includes('staging')) {
      url.pathname = `/v3/send/${channel}`;
    } else {
      url.pathname = `/v3-dev/send/${channel}`;
    }
    return url.toString();
  }
}
exports.SenderUtils = SenderUtils;