"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSearchByTimelineId = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSearchByTimelineId = async (request, savedSearchIds) => {
  if (savedSearchIds !== undefined) {
    const savedObjectsClient = (await request.context.core).savedObjects.client;
    const objects = savedSearchIds.map(id => ({
      id,
      type: 'search'
    }));
    await savedObjectsClient.bulkDelete(objects);
  } else {
    return Promise.resolve();
  }
};
exports.deleteSearchByTimelineId = deleteSearchByTimelineId;