"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExceptionsPreSingleListFindHandler = void 0;
var _errors = require("../validators/errors");
var _utils = require("../utils");
var _validators = require("../validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExceptionsPreSingleListFindHandler = endpointAppContextService => {
  return async function ({
    data,
    context: {
      request
    }
  }) {
    if (data.namespaceType !== 'agnostic') {
      return data;
    }
    let isEndpointArtifact = false;
    const {
      listId
    } = data;
    if (_validators.TrustedAppValidator.isTrustedApp({
      listId
    })) {
      // Validate Trusted applications
      isEndpointArtifact = true;
      await new _validators.TrustedAppValidator(endpointAppContextService, request).validatePreSingleListFind();
    } else if (_validators.TrustedDeviceValidator.isTrustedDevice({
      listId
    })) {
      // Validate Trusted Devices
      isEndpointArtifact = true;
      await new _validators.TrustedDeviceValidator(endpointAppContextService, request).validatePreSingleListFind();
    } else if (_validators.HostIsolationExceptionsValidator.isHostIsolationException({
      listId
    })) {
      // Host Isolation Exceptions
      isEndpointArtifact = true;
      await new _validators.HostIsolationExceptionsValidator(endpointAppContextService, request).validatePreSingleListFind();
    } else if (_validators.EventFilterValidator.isEventFilter({
      listId
    })) {
      // Event Filters Exceptions
      isEndpointArtifact = true;
      await new _validators.EventFilterValidator(endpointAppContextService, request).validatePreSingleListFind();
    }

    // Validate Blocklists
    if (_validators.BlocklistValidator.isBlocklist({
      listId
    })) {
      await new _validators.BlocklistValidator(endpointAppContextService, request).validatePreSingleListFind();
    } else if (_validators.EndpointExceptionsValidator.isEndpointException({
      listId
    })) {
      // Validate Endpoint Exceptions
      isEndpointArtifact = true;
      await new _validators.EndpointExceptionsValidator(endpointAppContextService, request).validatePreSingleListFind();
    } else if (_validators.EndpointExceptionsValidator.isEndpointException({
      listId
    })) {
      // Validate Endpoint Exceptions
      isEndpointArtifact = true;
      await new _validators.EndpointExceptionsValidator(endpointAppContextService, request).validatePreSingleListFind();
    }
    if (isEndpointArtifact) {
      if (!request) {
        throw new _errors.EndpointArtifactExceptionValidationError(`Missing HTTP Request object`);
      }
      await (0, _utils.setFindRequestFilterScopeToActiveSpace)(endpointAppContextService, request, data);
    }
    return data;
  };
};
exports.getExceptionsPreSingleListFindHandler = getExceptionsPreSingleListFindHandler;