"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnabledProductFeatures = void 0;
var _pli_config = require("./pli_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the U (union) of all PLIs from the enabled productTypes in a single array.
 */
const getEnabledProductFeatures = productTypes => {
  return productTypes.reduce((productFeatures, {
    product_line: line,
    product_tier: tier
  }) => {
    productFeatures.push(..._pli_config.PLI_PRODUCT_FEATURES[line][tier]);
    return productFeatures;
  }, []);
};
exports.getEnabledProductFeatures = getEnabledProductFeatures;