"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectEmptyPrompt = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxPromptNotFound = require("@kbn/shared-ux-prompt-not-found");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/share/public/url_service/redirect/components/empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultTitle = _i18n.i18n.translate('share.urlService.redirect.components.Error.title', {
  defaultMessage: 'Unable to open URL',
  description: 'Title displayed to user in redirect endpoint when redirection cannot be performed successfully.'
});
const defaultBody = _i18n.i18n.translate('share.urlService.redirect.components.Error.body', {
  defaultMessage: `Sorry, the object you're looking for can't be found at this URL.` + ` It might have been removed or maybe it never existed.`
});
const RedirectEmptyPrompt = ({
  title = defaultTitle,
  body = defaultBody,
  homeHref,
  docTitle,
  error
}) => {
  // eslint-disable-next-line no-console
  console.error('Short URL redirect error', error);
  docTitle.change(_i18n.i18n.translate('share.urlService.redirect.components.docTitle', {
    defaultMessage: 'Not Found'
  }));
  return /*#__PURE__*/React.createElement(_sharedUxPromptNotFound.NotFoundPrompt, {
    title: /*#__PURE__*/React.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 14
      }
    }, title),
    body: /*#__PURE__*/React.createElement("p", {
      "data-test-subj": "redirectErrorEmptyPromptBody",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }, body),
    actions: /*#__PURE__*/React.createElement(_eui.EuiButtonEmpty, {
      iconType: "arrowLeft",
      href: homeHref,
      "data-test-subj": "redirectErrorEmptyPromptButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('share.urlService.redirect.components.Error.homeButton', {
      defaultMessage: 'Back to home'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  });
};
exports.RedirectEmptyPrompt = RedirectEmptyPrompt;