"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRateRuleEditor = BurnRateRuleEditor;
var _react = _interopRequireWildcard(require("react"));
var _sloSchema = require("@kbn/slo-schema");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_fetch_slo_details = require("../../hooks/use_fetch_slo_details");
var _slo_selector = require("./slo_selector");
var _windows = require("./windows");
var _constants = require("./constants");
var _alert_time_table = require("./alert_time_table");
var _groupings = require("../../utils/slo/groupings");
var _dependencies = require("./dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/burn_rate_rule_editor/burn_rate_rule_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function BurnRateRuleEditor(props) {
  const {
    setRuleParams,
    ruleParams,
    errors
  } = props;
  const {
    data: initialSlo
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId: ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.sloId
  });
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)(undefined);
  const [windowDefs, setWindowDefs] = (0, _react.useState)((ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.windows) || []);
  const [dependencies, setDependencies] = (0, _react.useState)((ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.dependencies) || []);
  (0, _react.useEffect)(() => {
    setSelectedSlo(initialSlo);
    setWindowDefs(previous => {
      if (previous.length > 0) {
        return previous;
      }
      return createDefaultWindows(initialSlo);
    });
  }, [initialSlo]);
  const onSelectedSlo = slo => {
    setSelectedSlo(slo);
    setWindowDefs(() => {
      return createDefaultWindows(slo);
    });
    setRuleParams('sloId', slo === null || slo === void 0 ? void 0 : slo.id);
  };
  (0, _react.useEffect)(() => {
    setRuleParams('windows', windowDefs);
  }, [windowDefs, setRuleParams]);
  (0, _react.useEffect)(() => {
    setRuleParams('dependencies', dependencies);
  }, [dependencies, setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.slo.burnRateRuleEditor.h5.chooseASLOToMonitorLabel', {
    defaultMessage: 'Choose a SLO to monitor'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_selector.SloSelector, {
    initialSlo: selectedSlo,
    onSelected: onSelectedSlo,
    errors: errors.sloId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), (selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.groupBy) && ![selectedSlo.groupBy].flat().includes(_sloSchema.ALL_VALUE) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    title: _i18n.i18n.translate('xpack.slo.rules.groupByMessage', {
      defaultMessage: 'The SLO you selected has been created with a group-by on {groupByField}. This rule will monitor and generate an alert for every instance found in the group-by field.',
      values: {
        groupByField: (0, _groupings.getGroupKeysProse)(selectedSlo.groupBy)
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), selectedSlo && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_windows.Windows, {
    slo: selectedSlo,
    windows: windowDefs,
    onChange: setWindowDefs,
    errors: errors.windows,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_time_table.AlertTimeTable, {
    slo: selectedSlo,
    windows: windowDefs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  })), selectedSlo && /*#__PURE__*/_react.default.createElement(_dependencies.Dependencies, {
    currentRuleId: props.id,
    dependencies: dependencies,
    onChange: setDependencies,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }));
}
function createDefaultWindows(slo) {
  const burnRateDefaults = slo ? _constants.BURN_RATE_DEFAULTS[slo.timeWindow.duration] : [];
  return burnRateDefaults.map(partialWindow => (0, _windows.createNewWindow)(slo, partialWindow));
}