"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkPurgeConfirmationContainer = BulkPurgeConfirmationContainer;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_bulk_purge_rollup_data = require("../../../pages/slo_management/hooks/use_bulk_purge_rollup_data");
var _purge_confirmation_modal = require("./purge_confirmation_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/purge_confirmation_modal/bulk_purge_modal_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function BulkPurgeConfirmationContainer({
  items,
  onCancel,
  onConfirm
}) {
  const {
    mutate: bulkPurge
  } = (0, _use_bulk_purge_rollup_data.useBulkPurgeRollupData)({
    onConfirm
  });
  const onClickConfirm = purgePolicyData => {
    const {
      purgeDate,
      purgeType,
      forcePurge,
      age
    } = purgePolicyData;
    bulkPurge({
      list: items.map(({
        id
      }) => id),
      purgePolicy: purgeType === 'fixed_age' ? {
        purgeType: 'fixed_age',
        age
      } : {
        purgeType: 'fixed_time',
        timestamp: purgeDate.toISOString()
      },
      force: forcePurge
    });
  };
  const MODAL_TITLE = _i18n.i18n.translate('xpack.slo.bulkPurgeConfirmationModal.title', {
    defaultMessage: 'Purge {count} SLOs',
    values: {
      count: items.length
    }
  });
  const PURGE_POLICY_HELP_TEXT = _i18n.i18n.translate('xpack.slo.bulkPurgeConfirmationModal.descriptionText', {
    defaultMessage: 'Rollup data for {count} SLOs will be purged according to the policy provided below.',
    values: {
      count: items.length
    }
  });
  return /*#__PURE__*/_react.default.createElement(_purge_confirmation_modal.SloPurgeConfirmationModal, {
    onCancel: onCancel,
    onConfirm: onClickConfirm,
    modalTitle: MODAL_TITLE,
    purgePolicyHelpText: PURGE_POLICY_HELP_TEXT,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
}