"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloGroups = useFetchSloGroups;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _constants = require("../../common/constants");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
var _use_create_data_view = require("./use_create_data_view");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloGroups({
  page = 1,
  perPage = _constants.DEFAULT_SLO_GROUPS_PAGE_SIZE,
  groupBy = 'ungrouped',
  groupsFilter = [],
  kqlQuery = '',
  tagsFilter,
  statusFilter,
  filters: filterDSL = [],
  lastRefresh
} = {}) {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: _constants.SUMMARY_DESTINATION_INDEX_PATTERN
  });
  const filters = (0, _react.useMemo)(() => {
    try {
      return JSON.stringify((0, _esQuery.buildQueryFromFilters)([...filterDSL, ...(tagsFilter ? [tagsFilter] : []), ...(statusFilter ? [statusFilter] : [])], dataView, {
        ignoreFilterIfFieldNotInIndex: true
      }));
    } catch (e) {
      return '';
    }
  }, [filterDSL, tagsFilter, statusFilter, dataView]);
  const {
    data,
    isLoading,
    isSuccess,
    isError,
    isRefetching,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.group({
      page,
      perPage,
      groupBy,
      groupsFilter,
      kqlQuery,
      filters,
      lastRefresh
    }),
    queryFn: async ({
      signal
    }) => {
      const response = await sloClient.fetch('GET /internal/observability/slos/_groups', {
        params: {
          query: {
            ...(page && {
              page: String(page)
            }),
            ...(perPage && {
              perPage: String(perPage)
            }),
            ...(groupBy && {
              groupBy
            }),
            ...(groupsFilter && {
              groupsFilter
            }),
            ...(kqlQuery && {
              kqlQuery
            }),
            ...(filters && {
              filters
            })
          }
        },
        signal
      });
      return response;
    },
    cacheTime: 0,
    refetchOnWindowFocus: false,
    retry: (failureCount, error) => {
      if (String(error) === 'Error: Forbidden') {
        return false;
      }
      return failureCount < 4;
    },
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.slo.groups.list.errorNotification', {
          defaultMessage: 'Something went wrong while fetching SLO Groups'
        })
      });
    }
  });
  return {
    data,
    isLoading,
    isSuccess,
    isError,
    isRefetching,
    refetch
  };
}