"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdhocDataViews = exports.getDataViewPatternOrId = void 0;
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _use_kibana = require("../../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDataViewPatternOrId = ({
  byId,
  byPattern,
  dataViewsList,
  adHocDataViews
}) => {
  const allDataViews = [...(dataViewsList !== null && dataViewsList !== void 0 ? dataViewsList : []), ...adHocDataViews.map(dv => ({
    id: dv.id,
    title: dv.getIndexPattern()
  }))];
  if (byId) {
    var _allDataViews$find;
    return (_allDataViews$find = allDataViews.find(dv => dv.id === byId)) === null || _allDataViews$find === void 0 ? void 0 : _allDataViews$find.title;
  }
  if (byPattern) {
    var _allDataViews$find2;
    return (_allDataViews$find2 = allDataViews.find(dv => dv.title === byPattern)) === null || _allDataViews$find2 === void 0 ? void 0 : _allDataViews$find2.id;
  }
};
exports.getDataViewPatternOrId = getDataViewPatternOrId;
const useAdhocDataViews = ({
  currentIndexPattern
}) => {
  const {
    isLoading: isDataViewsLoading,
    data: dataViewsList = [],
    refetch: refetchDataViewsList
  } = (0, _public.useFetchDataViews)();
  const {
    dataViews: dataViewsService
  } = (0, _use_kibana.useKibana)().services;
  const [adHocDataViews, setAdHocDataViews] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (!isDataViewsLoading) {
      const missingDataView = getDataViewPatternOrId({
        byPattern: currentIndexPattern,
        dataViewsList,
        adHocDataViews
      });
      if (!missingDataView && currentIndexPattern) {
        async function loadMissingDataView() {
          const dataView = await dataViewsService.create({
            title: currentIndexPattern,
            allowNoIndex: true
          }, true);
          if (dataView.getIndexPattern() === currentIndexPattern) {
            setAdHocDataViews(prev => [...prev, dataView]);
          }
        }
        loadMissingDataView();
      }
    }
  }, [adHocDataViews, currentIndexPattern, dataViewsList, dataViewsService, isDataViewsLoading]);
  return {
    adHocDataViews,
    setAdHocDataViews,
    dataViewsList,
    isDataViewsLoading,
    refetchDataViewsList
  };
};
exports.useAdhocDataViews = useAdhocDataViews;