"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUnregisterFields = useUnregisterFields;
var _std = require("@kbn/std");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _react = require("react");
var _reactHookForm = require("react-hook-form");
var _use_fetch_apm_indices = require("../../../hooks/use_fetch_apm_indices");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook handles the unregistration of inputs when selecting another SLI indicator.
 * We could not use shouldUnregister on the controlled form fields because of a bug when submitting the form
 * which was unmounting the components and therefore unregistering the associated values.
 */
function useUnregisterFields({
  isEditMode
}) {
  const {
    data: apmIndex
  } = (0, _use_fetch_apm_indices.useFetchApmIndex)();
  const {
    watch,
    unregister,
    reset,
    resetField
  } = (0, _reactHookForm.useFormContext)();
  const [indicatorTypeState, setIndicatorTypeState] = (0, _react.useState)(watch('indicator.type'));
  const indicatorType = watch('indicator.type');
  (0, _react.useEffect)(() => {
    if (indicatorType !== indicatorTypeState && !isEditMode) {
      setIndicatorTypeState(indicatorType);
      unregister('indicator.params');
      switch (indicatorType) {
        case 'sli.metric.custom':
          reset(Object.assign({}, _constants.SLO_EDIT_FORM_DEFAULT_VALUES, {
            indicator: _constants.CUSTOM_METRIC_DEFAULT_VALUES
          }), {
            keepDefaultValues: true
          });
          break;
        case 'sli.metric.timeslice':
          reset(Object.assign({}, _constants.SLO_EDIT_FORM_DEFAULT_VALUES, {
            budgetingMethod: _constants.BUDGETING_METHOD_OPTIONS[1].value,
            objective: {
              target: 99,
              timesliceTarget: 95,
              timesliceWindow: 1
            },
            indicator: _constants.TIMESLICE_METRIC_DEFAULT_VALUES
          }), {
            keepDefaultValues: true
          });
          break;
        case 'sli.kql.custom':
          reset(Object.assign({}, _constants.SLO_EDIT_FORM_DEFAULT_VALUES, {
            indicator: _constants.CUSTOM_KQL_DEFAULT_VALUES
          }), {
            keepDefaultValues: true
          });
          break;
        case 'sli.histogram.custom':
          reset(Object.assign({}, _constants.SLO_EDIT_FORM_DEFAULT_VALUES, {
            indicator: _constants.HISTOGRAM_DEFAULT_VALUES
          }), {
            keepDefaultValues: true
          });
          break;
        case 'sli.apm.transactionDuration':
          reset(Object.assign({}, _constants.SLO_EDIT_FORM_DEFAULT_VALUES, {
            indicator: (0, _deepmerge.default)(_constants.APM_LATENCY_DEFAULT_VALUES, {
              params: {
                index: apmIndex
              }
            })
          }), {
            keepDefaultValues: true
          });
          break;
        case 'sli.apm.transactionErrorRate':
          reset(Object.assign({}, _constants.SLO_EDIT_FORM_DEFAULT_VALUES, {
            indicator: (0, _deepmerge.default)(_constants.APM_AVAILABILITY_DEFAULT_VALUES, {
              params: {
                index: apmIndex
              }
            })
          }), {
            keepDefaultValues: true
          });
          break;
        case 'sli.synthetics.availability':
          reset(Object.assign({}, _constants.SLO_EDIT_FORM_DEFAULT_VALUES_SYNTHETICS_AVAILABILITY), {
            keepDefaultValues: true
          });
          break;
        default:
          (0, _std.assertNever)(indicatorType);
      }
    }
  }, [isEditMode, indicatorType, indicatorTypeState, unregister, reset, resetField, apmIndex]);
}