"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSloSummary = getSloSummary;
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getSloSummary(esClient, slo, instanceId) {
  try {
    const res = await esClient.search({
      index: _constants.SUMMARY_DESTINATION_INDEX_PATTERN,
      query: {
        bool: {
          filter: [{
            term: {
              'slo.id': slo.id
            }
          }, {
            term: {
              'slo.revision': slo.revision
            }
          }, {
            term: {
              'slo.instanceId': instanceId
            }
          }]
        }
      },
      size: 1
    });
    if (res.hits.hits.length === 0) {
      return undefined;
    }
    return res.hits.hits[0]._source;
  } catch (err) {
    // noop
    return undefined;
  }
}