"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiagnosisRoute = void 0;
var _elasticsearch = require("@elastic/elasticsearch");
var _boom = require("@hapi/boom");
var _get_diagnosis = require("../../services/get_diagnosis");
var _create_slo_server_route = require("../create_slo_server_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDiagnosisRoute = exports.getDiagnosisRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /internal/observability/slos/_diagnosis',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      enabled: false,
      reason: 'The endpoint is used to diagnose SLOs and does not require any specific privileges.'
    }
  },
  params: undefined,
  handler: async ({
    request,
    logger,
    plugins,
    getScopedClients
  }) => {
    const {
      scopedClusterClient
    } = await getScopedClients({
      request,
      logger
    });
    const licensing = await plugins.licensing.start();
    try {
      return await (0, _get_diagnosis.getGlobalDiagnosis)(scopedClusterClient.asCurrentUser, licensing);
    } catch (error) {
      if (error instanceof _elasticsearch.errors.ResponseError && error.statusCode === 403) {
        throw (0, _boom.forbidden)('Insufficient Elasticsearch cluster permissions to access feature.');
      }
      throw (0, _boom.failedDependency)(error);
    }
  }
});