"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _app_context = require("../../../../app_context");
var _components = require("../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/restore_list/restore_table/shards_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    /*
     * 1. Adjust table styling to differentiate from parent table
     * 2. Allow child progress bar to expand to container size
     */
    shardsTable: (0, _react2.css)`
      margin: ${euiTheme.size.s} 0 ${euiTheme.size.s} ${euiTheme.size.l}; /* 1 */

      .euiToolTipAnchor {
        width: 100%; /* 2 */
      }

      .euiTable {
        background: none;

        .euiTableRow:last-child > .euiTableRowCell {
          border-bottom: none;
        }

        .euiTableRow:hover,
        .euiTableRow:hover > .euiTableRowCell {
          background: ${euiTheme.colors.lightestShade};
        }
      }
    `
  };
};
const ShardsTable = ({
  shards
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const styles = useStyles();
  const Progress = ({
    total,
    restored,
    percent
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.progressTooltipLabel', {
      defaultMessage: '{restored} of {total} restored',
      values: {
        restored,
        total
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    size: "xs",
    textAlign: "center",
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: total === 0 ? 1 : restored,
    max: total === 0 ? 1 : total,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }), percent));
  const columns = [{
    field: 'id',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.indexColumnTitle', {
      defaultMessage: 'ID'
    }),
    width: '40px',
    render: (id, shard) => shard.primary ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }, id), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.restoreList.shardTable.primaryTooltipLabel",
        defaultMessage: "Primary",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 19
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreList.shardTable.primaryAbbreviationText",
      defaultMessage: "P",
      description: "Used as an abbreviation for 'Primary', as in 'Primary shard'",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 19
      }
    }))))) : id
  }, {
    field: 'stage',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.stageColumnTitle', {
      defaultMessage: 'Stage'
    })
  }, {
    field: 'startTimeInMillis',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.startTimeColumnTitle', {
      defaultMessage: 'Start time'
    }),
    render: startTimeInMillis => startTimeInMillis ? /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: startTimeInMillis,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    })
  }, {
    field: 'stopTimeInMillis',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.endTimeColumnTitle', {
      defaultMessage: 'End time'
    }),
    render: stopTimeInMillis => stopTimeInMillis ? /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: stopTimeInMillis,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    })
  }, {
    field: 'totalTimeInMillis',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.durationColumnTitle', {
      defaultMessage: 'Duration'
    }),
    render: totalTimeInMillis => totalTimeInMillis ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreList.shardTable.durationValue",
      defaultMessage: "{seconds} {seconds, plural, one {second} other {seconds}}",
      values: {
        seconds: Math.ceil(totalTimeInMillis / 1000)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    })
  }, {
    field: 'repository',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.repositoryColumnTitle', {
      defaultMessage: 'Repository'
    })
  }, {
    field: 'snapshot',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.snapshotColumnTitle', {
      defaultMessage: 'Snapshot'
    })
  }, {
    field: 'version',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.versionColumnTitle', {
      defaultMessage: 'Version'
    })
  }, {
    field: 'targetHost',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.targetHostColumnTitle', {
      defaultMessage: 'Target host'
    })
  }, {
    field: 'targetNode',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.targetNodeColumnTitle', {
      defaultMessage: 'Target node'
    })
  }, {
    field: 'bytesTotal',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.bytesColumnTitle', {
      defaultMessage: 'Bytes'
    }),
    render: (bytesTotal, {
      bytesRecovered,
      bytesPercent
    }) => /*#__PURE__*/_react.default.createElement(Progress, {
      total: bytesTotal,
      restored: bytesRecovered,
      percent: bytesPercent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 12
      }
    })
  }, {
    field: 'filesTotal',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.filesColumnTitle', {
      defaultMessage: 'Files'
    }),
    render: (filesTotal, {
      filesRecovered,
      filesPercent
    }) => /*#__PURE__*/_react.default.createElement(Progress, {
      total: filesTotal,
      restored: filesRecovered,
      percent: filesPercent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 12
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    css: styles.shardsTable,
    compressed: true
    // @ts-ignore `shards` is a Partial<> but this component treats a number of fields as required
    ,
    items: shards,
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 5
    }
  });
};
exports.ShardsTable = ShardsTable;