"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldType = exports.EventType = exports.EventTracker = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let EventType = exports.EventType = /*#__PURE__*/function (EventType) {
  EventType["SPACE_SOLUTION_CHANGED"] = "space_solution_changed";
  EventType["SPACE_CHANGED"] = "space_changed";
  return EventType;
}({});
let FieldType = exports.FieldType = /*#__PURE__*/function (FieldType) {
  FieldType["ACTION"] = "action";
  FieldType["SPACE_ID"] = "space_id";
  FieldType["SPACE_ID_PREV"] = "space_id_prev";
  FieldType["SOLUTION"] = "solution";
  FieldType["SOLUTION_PREV"] = "solution_prev";
  return FieldType;
}({});
class EventTracker {
  constructor(analytics) {
    this.analytics = analytics;
  }
  track(eventType, eventFields) {
    try {
      this.analytics.reportEvent(eventType, eventFields);
    } catch (err) {
      // eslint-disable-next-line no-console
      console.error(err);
    }
  }

  /**
   * Track whenever the space "solution" is changed.
   */
  spaceSolutionChanged({
    spaceId,
    action,
    solution,
    solutionPrev
  }) {
    this.track(EventType.SPACE_SOLUTION_CHANGED, {
      [FieldType.SPACE_ID]: spaceId,
      [FieldType.SOLUTION]: solution,
      [FieldType.SOLUTION_PREV]: solutionPrev,
      [FieldType.ACTION]: action
    });
  }

  /**
   * Track whenever the user changes space.
   */
  changeSpace({
    prevSpaceId,
    prevSolution,
    nextSpaceId,
    nextSolution
  }) {
    this.track(EventType.SPACE_CHANGED, {
      [FieldType.SPACE_ID]: nextSpaceId,
      [FieldType.SPACE_ID_PREV]: prevSpaceId,
      [FieldType.SOLUTION]: nextSolution,
      [FieldType.SOLUTION_PREV]: prevSolution
    });
  }
}
exports.EventTracker = EventTracker;