"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SentinelOneSecretsSchema = exports.SentinelOneReleaseHostSchema = exports.SentinelOneIsolateHostSchema = exports.SentinelOneIsolateHostResponseSchema = exports.SentinelOneIsolateHostParamsSchema = exports.SentinelOneGetRemoteScriptsResponseSchema = exports.SentinelOneGetRemoteScriptsParamsSchema = exports.SentinelOneGetRemoteScriptStatusResponseSchema = exports.SentinelOneGetRemoteScriptStatusParamsSchema = exports.SentinelOneGetRemoteScriptResultsResponseSchema = exports.SentinelOneGetRemoteScriptResultsParamsSchema = exports.SentinelOneGetAgentsResponseSchema = exports.SentinelOneGetAgentsParamsSchema = exports.SentinelOneGetActivitiesResponseSchema = exports.SentinelOneGetActivitiesParamsSchema = exports.SentinelOneFetchAgentFilesResponseSchema = exports.SentinelOneFetchAgentFilesParamsSchema = exports.SentinelOneExecuteScriptSchema = exports.SentinelOneExecuteScriptResponseSchema = exports.SentinelOneExecuteScriptParamsSchema = exports.SentinelOneDownloadRemoteScriptResultsResponseSchema = exports.SentinelOneDownloadRemoteScriptResultsParamsSchema = exports.SentinelOneDownloadAgentFileResponseSchema = exports.SentinelOneDownloadAgentFileParamsSchema = exports.SentinelOneConfigSchema = exports.SentinelOneBaseFilterSchema = exports.SentinelOneBaseApiResponseSchema = exports.SentinelOneApiDoNotValidateResponsesSchema = exports.SentinelOneActionParamsSchema = exports.AlertIds = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

// Connector schema
const SentinelOneConfigSchema = exports.SentinelOneConfigSchema = _configSchema.schema.object({
  url: _configSchema.schema.string()
});
const SentinelOneSecretsSchema = exports.SentinelOneSecretsSchema = _configSchema.schema.object({
  token: _configSchema.schema.string()
});
const SentinelOneApiDoNotValidateResponsesSchema = exports.SentinelOneApiDoNotValidateResponsesSchema = _configSchema.schema.any();
const SentinelOneBaseApiResponseSchema = exports.SentinelOneBaseApiResponseSchema = _configSchema.schema.maybe(_configSchema.schema.object({}, {
  unknowns: 'allow'
}));
const SentinelOneGetAgentsResponseSchema = exports.SentinelOneGetAgentsResponseSchema = _configSchema.schema.object({
  pagination: _configSchema.schema.object({
    totalItems: _configSchema.schema.number(),
    nextCursor: _configSchema.schema.nullable(_configSchema.schema.string())
  }),
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  data: _configSchema.schema.arrayOf(_configSchema.schema.object({
    modelName: _configSchema.schema.string(),
    firewallEnabled: _configSchema.schema.boolean(),
    totalMemory: _configSchema.schema.number(),
    osName: _configSchema.schema.string(),
    cloudProviders: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
    siteName: _configSchema.schema.string(),
    cpuId: _configSchema.schema.string(),
    isPendingUninstall: _configSchema.schema.boolean(),
    isUpToDate: _configSchema.schema.boolean(),
    osArch: _configSchema.schema.string(),
    accountId: _configSchema.schema.string(),
    locationEnabled: _configSchema.schema.boolean(),
    consoleMigrationStatus: _configSchema.schema.string(),
    scanFinishedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    operationalStateExpiration: _configSchema.schema.nullable(_configSchema.schema.string()),
    agentVersion: _configSchema.schema.string(),
    isActive: _configSchema.schema.boolean(),
    locationType: _configSchema.schema.string(),
    activeThreats: _configSchema.schema.number(),
    inRemoteShellSession: _configSchema.schema.boolean(),
    allowRemoteShell: _configSchema.schema.boolean(),
    serialNumber: _configSchema.schema.nullable(_configSchema.schema.string()),
    updatedAt: _configSchema.schema.string(),
    lastActiveDate: _configSchema.schema.string(),
    firstFullModeTime: _configSchema.schema.nullable(_configSchema.schema.string()),
    operationalState: _configSchema.schema.string(),
    externalId: _configSchema.schema.string(),
    mitigationModeSuspicious: _configSchema.schema.string(),
    licenseKey: _configSchema.schema.string(),
    cpuCount: _configSchema.schema.number(),
    mitigationMode: _configSchema.schema.string(),
    networkStatus: _configSchema.schema.string(),
    installerType: _configSchema.schema.string(),
    uuid: _configSchema.schema.string(),
    detectionState: _configSchema.schema.nullable(_configSchema.schema.string()),
    infected: _configSchema.schema.boolean(),
    registeredAt: _configSchema.schema.string(),
    lastIpToMgmt: _configSchema.schema.string(),
    storageName: _configSchema.schema.nullable(_configSchema.schema.string()),
    osUsername: _configSchema.schema.nullable(_configSchema.schema.string()),
    groupIp: _configSchema.schema.string(),
    createdAt: _configSchema.schema.string(),
    remoteProfilingState: _configSchema.schema.string(),
    groupUpdatedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    scanAbortedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    isUninstalled: _configSchema.schema.boolean(),
    networkQuarantineEnabled: _configSchema.schema.boolean(),
    tags: _configSchema.schema.object({
      sentinelone: _configSchema.schema.arrayOf(_configSchema.schema.object({
        assignedBy: _configSchema.schema.string(),
        assignedAt: _configSchema.schema.string(),
        assignedById: _configSchema.schema.string(),
        key: _configSchema.schema.string(),
        value: _configSchema.schema.string(),
        id: _configSchema.schema.string()
      }))
    }),
    externalIp: _configSchema.schema.string(),
    siteId: _configSchema.schema.string(),
    machineType: _configSchema.schema.string(),
    domain: _configSchema.schema.string(),
    scanStatus: _configSchema.schema.string(),
    osStartTime: _configSchema.schema.string(),
    accountName: _configSchema.schema.string(),
    lastLoggedInUserName: _configSchema.schema.string(),
    showAlertIcon: _configSchema.schema.boolean(),
    rangerStatus: _configSchema.schema.string(),
    groupName: _configSchema.schema.string(),
    threatRebootRequired: _configSchema.schema.boolean(),
    remoteProfilingStateExpiration: _configSchema.schema.nullable(_configSchema.schema.string()),
    policyUpdatedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    activeDirectory: _configSchema.schema.object({
      userPrincipalName: _configSchema.schema.nullable(_configSchema.schema.string()),
      lastUserDistinguishedName: _configSchema.schema.nullable(_configSchema.schema.string()),
      computerMemberOf: _configSchema.schema.arrayOf(_configSchema.schema.object({
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })),
      lastUserMemberOf: _configSchema.schema.arrayOf(_configSchema.schema.object({
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })),
      mail: _configSchema.schema.nullable(_configSchema.schema.string()),
      computerDistinguishedName: _configSchema.schema.nullable(_configSchema.schema.string())
    }, {
      unknowns: 'allow'
    }),
    isDecommissioned: _configSchema.schema.boolean(),
    rangerVersion: _configSchema.schema.string(),
    userActionsNeeded: _configSchema.schema.arrayOf(_configSchema.schema.object({
      type: _configSchema.schema.string(),
      example: _configSchema.schema.string(),
      enum: _configSchema.schema.arrayOf(_configSchema.schema.string())
    }, {
      unknowns: 'allow'
    })),
    locations: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
      name: _configSchema.schema.string(),
      scope: _configSchema.schema.string(),
      id: _configSchema.schema.string()
    }, {
      unknowns: 'allow'
    }))),
    id: _configSchema.schema.string(),
    coreCount: _configSchema.schema.number(),
    osRevision: _configSchema.schema.string(),
    osType: _configSchema.schema.string(),
    groupId: _configSchema.schema.string(),
    computerName: _configSchema.schema.string(),
    scanStartedAt: _configSchema.schema.string(),
    encryptedApplications: _configSchema.schema.boolean(),
    storageType: _configSchema.schema.nullable(_configSchema.schema.string()),
    networkInterfaces: _configSchema.schema.arrayOf(_configSchema.schema.object({
      gatewayMacAddress: _configSchema.schema.nullable(_configSchema.schema.string()),
      inet6: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      name: _configSchema.schema.string(),
      inet: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      physical: _configSchema.schema.string(),
      gatewayIp: _configSchema.schema.nullable(_configSchema.schema.string()),
      id: _configSchema.schema.string()
    }, {
      unknowns: 'allow'
    })),
    fullDiskScanLastUpdatedAt: _configSchema.schema.string(),
    appsVulnerabilityStatus: _configSchema.schema.string()
  }, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const SentinelOneIsolateHostResponseSchema = exports.SentinelOneIsolateHostResponseSchema = _configSchema.schema.object({
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  data: _configSchema.schema.object({
    affected: _configSchema.schema.number()
  }, {
    unknowns: 'allow'
  })
});
const SentinelOneGetRemoteScriptsParamsSchema = exports.SentinelOneGetRemoteScriptsParamsSchema = _configSchema.schema.object({
  query: _configSchema.schema.nullable(_configSchema.schema.string()),
  // Possible values (multiples comma delimiter): `linux` or `macos` or `windows`
  osTypes: _configSchema.schema.nullable(_configSchema.schema.string()),
  // possible values (multiples comma delimiter): `action` or `artifactCollection` or `dataCollection`
  scriptType: _configSchema.schema.nullable(_configSchema.schema.string()),
  // Cursor position returned by the last request. Use to iterate over more than 1000 items. Example: "YWdlbnRfaWQ6NTgwMjkzODE=".
  cursor: _configSchema.schema.nullable(_configSchema.schema.string()),
  // List of group IDs to filter by. Example: "225494730938493804,225494730938493915".
  groupIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  // A list of script IDs. Example: "225494730938493804,225494730938493915".
  ids: _configSchema.schema.nullable(_configSchema.schema.string()),
  // Is the script runnable in Advanced Response Scripts
  isAvailableForArs: _configSchema.schema.nullable(_configSchema.schema.boolean()),
  // Limit number of returned items (1-1000). Example: "10".
  limit: _configSchema.schema.nullable(_configSchema.schema.number({
    max: 1000,
    min: 1,
    defaultValue: 10
  })),
  // List of Site IDs to filter by. Example: "225494730938493804,225494730938493915".
  siteIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  // Skip first number of items (0-1000). To iterate over more than 1000 items, use "cursor". Example: "150".
  skip: _configSchema.schema.nullable(_configSchema.schema.number()),
  // If true, total number of items will not be calculated, which speeds up execution time.
  skipCount: _configSchema.schema.nullable(_configSchema.schema.boolean()),
  // The column to sort the results by. Example: "id".
  sortBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  // Sort direction. Example: "asc" or "desc"
  sortOrder: _configSchema.schema.nullable(_configSchema.schema.string())
});
const SentinelOneFetchAgentFilesParamsSchema = exports.SentinelOneFetchAgentFilesParamsSchema = _configSchema.schema.object({
  agentId: _configSchema.schema.string({
    minLength: 1
  }),
  zipPassCode: _configSchema.schema.string({
    minLength: 10
  }),
  files: _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }))
});
const SentinelOneFetchAgentFilesResponseSchema = exports.SentinelOneFetchAgentFilesResponseSchema = _configSchema.schema.object({
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  data: _configSchema.schema.maybe(_configSchema.schema.object({
    success: _configSchema.schema.boolean()
  }, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const SentinelOneDownloadAgentFileParamsSchema = exports.SentinelOneDownloadAgentFileParamsSchema = _configSchema.schema.object({
  agentId: _configSchema.schema.string({
    minLength: 1
  }),
  activityId: _configSchema.schema.string({
    minLength: 1
  })
});
const SentinelOneDownloadAgentFileResponseSchema = exports.SentinelOneDownloadAgentFileResponseSchema = _configSchema.schema.stream();
const SentinelOneGetActivitiesParamsSchema = exports.SentinelOneGetActivitiesParamsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  accountIds: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  activityTypes: _configSchema.schema.maybe(_configSchema.schema.string()),
  activityUuids: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  agentIds: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  alertIds: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  countOnly: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  createdAt__between: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  createdAt__gt: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  createdAt__gte: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  createdAt__lt: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  createdAt__lte: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  cursor: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  groupIds: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  ids: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  includeHidden: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  limit: _configSchema.schema.maybe(_configSchema.schema.number()),
  ruleIds: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  siteIds: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  skip: _configSchema.schema.maybe(_configSchema.schema.number()),
  skipCount: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  sortBy: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  sortOrder: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  threatIds: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  userEmails: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  })),
  userIds: _configSchema.schema.maybe(_configSchema.schema.string({
    minLength: 1
  }))
}));
const SentinelOneGetActivitiesResponseSchema = exports.SentinelOneGetActivitiesResponseSchema = _configSchema.schema.object({
  errors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  pagination: _configSchema.schema.object({
    nextCursor: _configSchema.schema.nullable(_configSchema.schema.string()),
    totalItems: _configSchema.schema.number()
  }),
  data: _configSchema.schema.arrayOf(_configSchema.schema.object({
    accountId: _configSchema.schema.string(),
    accountName: _configSchema.schema.string(),
    activityType: _configSchema.schema.number(),
    activityUuid: _configSchema.schema.string(),
    agentId: _configSchema.schema.nullable(_configSchema.schema.string()),
    agentUpdatedVersion: _configSchema.schema.nullable(_configSchema.schema.string()),
    comments: _configSchema.schema.nullable(_configSchema.schema.string()),
    createdAt: _configSchema.schema.string(),
    data: _configSchema.schema.object({
      // Empty by design.
      // The SentinelOne Activity Log can place any (unknown) data here
    }, {
      unknowns: 'allow'
    }),
    description: _configSchema.schema.nullable(_configSchema.schema.string()),
    groupId: _configSchema.schema.nullable(_configSchema.schema.string()),
    groupName: _configSchema.schema.nullable(_configSchema.schema.string()),
    hash: _configSchema.schema.nullable(_configSchema.schema.string()),
    id: _configSchema.schema.string(),
    osFamily: _configSchema.schema.nullable(_configSchema.schema.string()),
    primaryDescription: _configSchema.schema.nullable(_configSchema.schema.string()),
    secondaryDescription: _configSchema.schema.nullable(_configSchema.schema.string()),
    siteId: _configSchema.schema.string(),
    siteName: _configSchema.schema.string(),
    threatId: _configSchema.schema.nullable(_configSchema.schema.string()),
    updatedAt: _configSchema.schema.string(),
    userId: _configSchema.schema.nullable(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const AlertIds = exports.AlertIds = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()));
const SentinelOneGetRemoteScriptsResponseSchema = exports.SentinelOneGetRemoteScriptsResponseSchema = _configSchema.schema.object({
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  pagination: _configSchema.schema.object({
    nextCursor: _configSchema.schema.nullable(_configSchema.schema.string()),
    totalItems: _configSchema.schema.number()
  }),
  data: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    updater: _configSchema.schema.nullable(_configSchema.schema.string()),
    isAvailableForLite: _configSchema.schema.boolean(),
    isAvailableForArs: _configSchema.schema.boolean(),
    fileSize: _configSchema.schema.number(),
    mgmtId: _configSchema.schema.number(),
    scopeLevel: _configSchema.schema.string(),
    shortFileName: _configSchema.schema.string(),
    scriptName: _configSchema.schema.string(),
    creator: _configSchema.schema.string(),
    package: _configSchema.schema.nullable(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      bucketName: _configSchema.schema.string(),
      endpointExpiration: _configSchema.schema.string(),
      fileName: _configSchema.schema.string(),
      endpointExpirationSeconds: _configSchema.schema.nullable(_configSchema.schema.number()),
      fileSize: _configSchema.schema.number(),
      signatureType: _configSchema.schema.string(),
      signature: _configSchema.schema.string()
    }, {
      unknowns: 'allow'
    })),
    bucketName: _configSchema.schema.string(),
    inputRequired: _configSchema.schema.boolean(),
    fileName: _configSchema.schema.string(),
    supportedDestinations: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    scopeName: _configSchema.schema.nullable(_configSchema.schema.string()),
    signatureType: _configSchema.schema.string(),
    outputFilePaths: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    scriptDescription: _configSchema.schema.nullable(_configSchema.schema.string()),
    createdByUserId: _configSchema.schema.string(),
    scopeId: _configSchema.schema.string(),
    updatedAt: _configSchema.schema.string(),
    scriptType: _configSchema.schema.string(),
    scopePath: _configSchema.schema.string(),
    creatorId: _configSchema.schema.string(),
    osTypes: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    scriptRuntimeTimeoutSeconds: _configSchema.schema.number(),
    version: _configSchema.schema.string(),
    updaterId: _configSchema.schema.nullable(_configSchema.schema.string()),
    createdAt: _configSchema.schema.string(),
    inputExample: _configSchema.schema.nullable(_configSchema.schema.string()),
    inputInstructions: _configSchema.schema.nullable(_configSchema.schema.string()),
    signature: _configSchema.schema.string(),
    createdByUser: _configSchema.schema.string(),
    requiresApproval: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const SentinelOneExecuteScriptParamsSchema = exports.SentinelOneExecuteScriptParamsSchema = _configSchema.schema.object({
  // Only a sub-set of filters are defined below. This API, however, support many more filters
  // which can be added in the future if needed.
  filter: _configSchema.schema.object({
    uuids: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1
    })),
    ids: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1
    }))
  }),
  script: _configSchema.schema.object({
    apiKey: _configSchema.schema.maybe(_configSchema.schema.string()),
    inputParams: _configSchema.schema.maybe(_configSchema.schema.string()),
    outputDirectory: _configSchema.schema.maybe(_configSchema.schema.string()),
    outputDestination: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('Local'), _configSchema.schema.literal('None'), _configSchema.schema.literal('SentinelCloud'), _configSchema.schema.literal('SingularityXDR')])),
    passwordFromScope: _configSchema.schema.maybe(_configSchema.schema.object({
      scopeLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
      scopeId: _configSchema.schema.maybe(_configSchema.schema.string())
    })),
    password: _configSchema.schema.maybe(_configSchema.schema.string()),
    requiresApproval: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    scriptId: _configSchema.schema.string(),
    scriptName: _configSchema.schema.maybe(_configSchema.schema.string()),
    scriptRuntimeTimeoutSeconds: _configSchema.schema.maybe(_configSchema.schema.number()),
    singularityxdrKeyword: _configSchema.schema.maybe(_configSchema.schema.string()),
    singularityxdrUrl: _configSchema.schema.maybe(_configSchema.schema.string()),
    taskDescription: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  alertIds: AlertIds
});
const SentinelOneExecuteScriptResponseSchema = exports.SentinelOneExecuteScriptResponseSchema = _configSchema.schema.object({
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))),
  data: _configSchema.schema.nullable(_configSchema.schema.object({
    pendingExecutionId: _configSchema.schema.nullable(_configSchema.schema.string()),
    affected: _configSchema.schema.nullable(_configSchema.schema.number()),
    parentTaskId: _configSchema.schema.nullable(_configSchema.schema.string()),
    pending: _configSchema.schema.nullable(_configSchema.schema.boolean())
  }, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const SentinelOneGetRemoteScriptResultsParamsSchema = exports.SentinelOneGetRemoteScriptResultsParamsSchema = _configSchema.schema.object({
  taskIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const SentinelOneGetRemoteScriptResultsResponseSchema = exports.SentinelOneGetRemoteScriptResultsResponseSchema = _configSchema.schema.object({
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string()
  }, {
    unknowns: 'allow'
  }))),
  data: _configSchema.schema.any()
}, {
  unknowns: 'allow'
});
const SentinelOneDownloadRemoteScriptResultsParamsSchema = exports.SentinelOneDownloadRemoteScriptResultsParamsSchema = _configSchema.schema.object({
  taskId: _configSchema.schema.string({
    minLength: 1
  })
});
const SentinelOneDownloadRemoteScriptResultsResponseSchema = exports.SentinelOneDownloadRemoteScriptResultsResponseSchema = _configSchema.schema.stream();
const SentinelOneGetRemoteScriptStatusParamsSchema = exports.SentinelOneGetRemoteScriptStatusParamsSchema = _configSchema.schema.object({
  parentTaskId: _configSchema.schema.string()
}, {
  unknowns: 'allow'
});
const SentinelOneGetRemoteScriptStatusResponseSchema = exports.SentinelOneGetRemoteScriptStatusResponseSchema = _configSchema.schema.object({
  pagination: _configSchema.schema.object({
    totalItems: _configSchema.schema.number(),
    nextCursor: _configSchema.schema.nullable(_configSchema.schema.string())
  }),
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string()
  }, {
    unknowns: 'allow'
  }))),
  data: _configSchema.schema.arrayOf(_configSchema.schema.mapOf(_configSchema.schema.string(), _configSchema.schema.any()))
}, {
  unknowns: 'allow'
});
const SentinelOneBaseFilterSchema = exports.SentinelOneBaseFilterSchema = _configSchema.schema.object({
  K8SNodeName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  adUserQuery__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerVersionsNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  operationalStatesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  appsVulnerabilityStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  mitigationMode: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  gatewayIp: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudImage__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatMitigationStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
  installerTypesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  appsVulnerabilityStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatResolved: _configSchema.schema.nullable(_configSchema.schema.string()),
  mitigationModeSuspicious: _configSchema.schema.nullable(_configSchema.schema.string()),
  isUpToDate: _configSchema.schema.nullable(_configSchema.schema.string()),
  adComputerQuery__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  azureResourceGroup__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  scanStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatContentHash: _configSchema.schema.nullable(_configSchema.schema.string()),
  osTypesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatRebootRequired: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  firewallEnabled: _configSchema.schema.nullable(_configSchema.schema.string()),
  gcpServiceAccount__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  remoteProfilingStates: _configSchema.schema.nullable(_configSchema.schema.string()),
  filteredGroupIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  agentVersions: _configSchema.schema.nullable(_configSchema.schema.string()),
  activeThreats: _configSchema.schema.nullable(_configSchema.schema.string()),
  machineTypesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  awsSubnetIds__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  installerTypes: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  migrationStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudTags__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  osArch: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  siteIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkInterfaceInet__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  groupIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  uuids: _configSchema.schema.nullable(_configSchema.schema.string()),
  accountIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  scanStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  locationIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  awsSecurityGroups__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  activeThreats__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  infected: _configSchema.schema.nullable(_configSchema.schema.string()),
  osVersion__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  machineTypes: _configSchema.schema.nullable(_configSchema.schema.string()),
  agentPodName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  computerName__like: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  consoleMigrationStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  computerName: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudInstanceId__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  remoteProfilingStatesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  adComputerMember__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  ids: _configSchema.schema.nullable(_configSchema.schema.string()),
  agentVersionsNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  locationEnabled: _configSchema.schema.nullable(_configSchema.schema.string()),
  locationIdsNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  osTypes: _configSchema.schema.nullable(_configSchema.schema.string()),
  encryptedApplications: _configSchema.schema.nullable(_configSchema.schema.string()),
  filterId: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  adUserMember__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  uuid: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudNetwork__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  clusterName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  query: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
  domains: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudProvider: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  scanStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  hasLocalConfiguration: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  isPendingUninstall: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  consoleMigrationStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  adQuery: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  adComputerName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudInstanceSize__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkQuarantineEnabled: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudAccount__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudLocation__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerVersions: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkInterfaceGatewayMacAddress__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  uuid__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  agentNamespace__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  K8SNodeLabels__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  adQuery__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  K8SType__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  countsFor: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  externalId__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  filteredSiteIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatHidden: _configSchema.schema.nullable(_configSchema.schema.string()),
  isUninstalled: _configSchema.schema.nullable(_configSchema.schema.string()),
  computerName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  adUserName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  isActive: _configSchema.schema.nullable(_configSchema.schema.string()),
  userActionsNeeded: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  domainsNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  operationalStates: _configSchema.schema.nullable(_configSchema.schema.string()),
  externalIp__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  isDecommissioned: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkInterfacePhysical__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastLoggedInUserName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  awsRole__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  K8SVersion__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  alertIds: AlertIds
});
const SentinelOneIsolateHostParamsSchema = exports.SentinelOneIsolateHostParamsSchema = SentinelOneBaseFilterSchema;
const SentinelOneGetAgentsParamsSchema = exports.SentinelOneGetAgentsParamsSchema = SentinelOneBaseFilterSchema;
const SentinelOneIsolateHostSchema = exports.SentinelOneIsolateHostSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.ISOLATE_HOST),
  subActionParams: SentinelOneIsolateHostParamsSchema
});
const SentinelOneReleaseHostSchema = exports.SentinelOneReleaseHostSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.RELEASE_HOST),
  subActionParams: SentinelOneIsolateHostParamsSchema
});
const SentinelOneExecuteScriptSchema = exports.SentinelOneExecuteScriptSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.EXECUTE_SCRIPT),
  subActionParams: SentinelOneExecuteScriptParamsSchema
});
const SentinelOneActionParamsSchema = exports.SentinelOneActionParamsSchema = _configSchema.schema.oneOf([SentinelOneIsolateHostSchema, SentinelOneReleaseHostSchema, SentinelOneExecuteScriptSchema]);