"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XSOARRunActionResponseSchema = exports.XSOARRunActionParamsSchema = exports.XSOARPlaybooksObjectSchema = exports.XSOARPlaybooksActionResponseSchema = exports.XSOARPlaybooksActionParamsSchema = exports.SecretsSchema = exports.ExecutorParamsSchema = exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  url: _configSchema.schema.string()
});
const SecretsSchema = exports.SecretsSchema = _configSchema.schema.object({
  apiKey: _configSchema.schema.string(),
  apiKeyID: _configSchema.schema.nullable(_configSchema.schema.string())
});
const XSOARPlaybooksActionParamsSchema = exports.XSOARPlaybooksActionParamsSchema = null;
const XSOARPlaybooksObjectSchema = exports.XSOARPlaybooksObjectSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string()
}, {
  unknowns: 'ignore'
});
const XSOARPlaybooksActionResponseSchema = exports.XSOARPlaybooksActionResponseSchema = _configSchema.schema.object({
  playbooks: _configSchema.schema.arrayOf(XSOARPlaybooksObjectSchema)
}, {
  unknowns: 'ignore'
});
const XSOARRunActionParamsSchema = exports.XSOARRunActionParamsSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  playbookId: _configSchema.schema.nullable(_configSchema.schema.string()),
  createInvestigation: _configSchema.schema.boolean(),
  severity: _configSchema.schema.number(),
  isRuleSeverity: _configSchema.schema.nullable(_configSchema.schema.boolean({
    defaultValue: false
  })),
  body: _configSchema.schema.nullable(_configSchema.schema.string())
});
const XSOARRunActionResponseSchema = exports.XSOARRunActionResponseSchema = _configSchema.schema.object({}, {
  unknowns: 'ignore'
});
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.PLAYBOOKS),
  subActionParams: _configSchema.schema.literal(null) // this subaction not required any value as params
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.RUN),
  subActionParams: XSOARRunActionParamsSchema
})]);